/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;

@Immutable
public enum FsUriModifier {
    NULL{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            if (uri.normalize() != uri) {
                throw new QuotedUriSyntaxException((Object)uri, "URI path not in normal form");
            }
            return uri;
        }
    }
    ,
    CANONICALIZE{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            return fix.modify(uri);
        }
    };


    abstract URI modify(URI var1, PostFix var2) throws URISyntaxException;

    public static enum PostFix {
        NODE_PATH{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uri) throws URISyntaxException {
                int l;
                String p;
                if (uri.isOpaque() || !uri.isAbsolute() || null != uri.getRawFragment()) {
                    return uri;
                }
                String a = uri.getRawAuthority();
                String p2 = uri.getRawPath();
                if (null == a && null != p2 && p2.startsWith(PostFix.TWO_SEPARATORS)) {
                    int i = p2.indexOf(47, 2);
                    if (2 <= i) {
                        a = p2.substring(2, i);
                        p2 = p2.substring(i);
                    }
                    uri = new UriBuilder(uri, true).authority(a).path(p2).getUri();
                }
                uri = uri.normalize();
                String s = uri.getScheme();
                String a2 = uri.getRawAuthority();
                String q = p = uri.getRawPath();
                while (p.endsWith("/") && (1 <= (l = p.length()) && null == s || 2 <= l && ':' != p.charAt(l - 2) || 3 <= l && !p.startsWith("/") || 4 < l && p.startsWith("/") || null != a2)) {
                    p = p.substring(0, l - 1);
                }
                return p != q ? new UriBuilder(uri, true).path(p).getUri() : uri;
            }
        }
        ,
        MOUNT_POINT{

            @Override
            URI modify(URI uri) {
                return uri.normalize();
            }
        }
        ,
        NODE_NAME{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uri) throws URISyntaxException {
                String p;
                if ((uri = uri.normalize()).isAbsolute() || null != uri.getRawAuthority() || null != uri.getRawFragment()) {
                    return uri;
                }
                String q = p = uri.getRawPath();
                while (p.startsWith("/")) {
                    p = p.substring(1);
                }
                while (p.endsWith("/")) {
                    p = p.substring(0, p.length() - 1);
                }
                return p == q ? uri : new UriBuilder(uri, true).path(p).getUri();
            }
        };

        private static final String TWO_SEPARATORS = "//";

        abstract URI modify(URI var1) throws URISyntaxException;
    }
}

