/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec.cmd;

import net.java.trueupdate.manager.spec.cmd.Command;

public final class CompositeCommand
implements Command {
    private final Command[] commands;
    private int index;

    public CompositeCommand(Command ... commands) {
        if (0 >= commands.length) {
            throw new IllegalArgumentException();
        }
        this.commands = (Command[])commands.clone();
    }

    @Override
    public void perform() throws Exception {
        if (0 != this.index) {
            throw new IllegalStateException("Not idempotent.");
        }
        while (this.index < this.commands.length) {
            this.commands[this.index++].perform();
        }
    }

    @Override
    public void revert() throws Exception {
        while (0 < this.index) {
            int i = this.index - 1;
            this.commands[i].revert();
            this.index = i;
        }
    }
}

