/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.plug.openejb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.FileStore;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.Sources;
import net.java.trueupdate.core.io.ZipEntrySink;
import net.java.trueupdate.core.io.ZipEntrySource;
import net.java.trueupdate.core.io.ZipInputTask;
import net.java.trueupdate.core.io.ZipOutputTask;
import net.java.trueupdate.core.io.ZipSinks;
import net.java.trueupdate.core.io.ZipSources;
import net.java.trueupdate.core.zip.patch.ZipPatch;

class Files {
    private static final Pattern COMPRESSED_FILE_EXTENSIONS = Pattern.compile(".*\\.(ear|jar|war|zip|gz|xz)", 2);

    private Files() {
    }

    public static boolean deleteAll(File file) throws IOException {
        if (file.isDirectory()) {
            for (File member : file.listFiles()) {
                if (Files.deleteAll(member)) continue;
                return false;
            }
        }
        return file.delete() || !file.exists();
    }

    public static void zipTo(File fileOrDirectory, File zipFile) throws IOException {
        class WithZipArchive
        implements ZipOutputTask<Void, IOException> {
            final /* synthetic */ File val$fileOrDirectory;

            WithZipArchive(File file) {
                this.val$fileOrDirectory = file;
            }

            public Void execute(final ZipOutputStream zipArchive) throws IOException {
                class Zipper {
                    Zipper() {
                    }

                    void zipDirectory(File directory, String name) throws IOException {
                        Object[] memberFiles = directory.listFiles();
                        Arrays.sort(memberFiles);
                        for (Object memberFile : memberFiles) {
                            String memberName = (name.isEmpty() ? name : name + '/') + ((File)memberFile).getName();
                            if (((File)memberFile).isDirectory()) {
                                this.zipDirectory((File)memberFile, memberName);
                                continue;
                            }
                            this.zipFile((File)memberFile, memberName);
                        }
                    }

                    void zipFile(File file, String name) throws IOException {
                        ZipEntry entry = this.entry(name);
                        if (COMPRESSED_FILE_EXTENSIONS.matcher(name).matches()) {
                            long length = file.length();
                            entry.setMethod(0);
                            entry.setSize(length);
                            entry.setCompressedSize(length);
                            entry.setCrc(this.crc32(file));
                        }
                        Copy.copy((Source)this.fileSource(file), (Sink)this.zipEntrySink(entry));
                    }

                    long crc32(File input) throws IOException {
                        CRC32 checksum = new CRC32();
                        class ReadTask
                        implements InputTask<Void, IOException> {
                            ReadTask() {
                            }

                            public Void execute(InputStream in) throws IOException {
                                while (-1 != in.read()) {
                                }
                                return null;
                            }
                        }
                        Sources.execute((InputTask)new ReadTask()).on((InputStream)new CheckedInputStream(new BufferedInputStream(new FileInputStream(input)), checksum));
                        return checksum.getValue();
                    }

                    Source fileSource(File file) {
                        return new FileStore(file);
                    }

                    Sink zipEntrySink(ZipEntry entry) {
                        return new ZipEntrySink(entry, zipArchive);
                    }

                    ZipEntry entry(String name) {
                        return new ZipEntry(name);
                    }
                }
                if (this.val$fileOrDirectory.isDirectory()) {
                    new Zipper().zipDirectory(this.val$fileOrDirectory, "");
                } else {
                    new Zipper().zipFile(this.val$fileOrDirectory, "");
                }
                return null;
            }
        }
        ZipSinks.execute((ZipOutputTask)new WithZipArchive(fileOrDirectory)).on(new ZipOutputStream(new FileOutputStream(zipFile)));
    }

    public static void unzipTo(File zipFile, File directory) throws IOException {
        class WithArchive
        implements ZipInputTask<Void, IOException> {
            final /* synthetic */ File val$directory;

            WithArchive(File file) {
                this.val$directory = file;
            }

            public Void execute(ZipFile zipArchive) throws IOException {
                Enumeration<? extends ZipEntry> en = zipArchive.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    if (entry.isDirectory()) continue;
                    File file = new File(this.val$directory, entry.getName());
                    file.getParentFile().mkdirs();
                    Copy.copy((Source)new ZipEntrySource(entry, zipArchive), (Sink)new FileStore(file));
                }
                return null;
            }
        }
        ZipSources.execute((ZipInputTask)new WithArchive(directory)).on(new ZipFile(zipFile));
    }

    public static void applyPatchTo(File inputFile, final File patchFile, final File patchedFile) throws IOException {
        class WithInputArchive
        implements ZipInputTask<Void, IOException> {
            WithInputArchive() {
            }

            public Void execute(final ZipFile inputArchive) throws IOException {
                class WithPatchArchive
                implements ZipInputTask<Void, IOException> {
                    WithPatchArchive() {
                    }

                    public Void execute(ZipFile patchArchive) throws IOException {
                        ZipPatch.builder().inputArchive(inputArchive).patchArchive(patchArchive).createJar(true).build().applyTo((Sink)new FileStore(patchedFile));
                        return null;
                    }
                }
                ZipSources.execute((ZipInputTask)new WithPatchArchive()).on(new ZipFile(patchFile));
                return null;
            }
        }
        ZipSources.execute((ZipInputTask)new WithInputArchive()).on(new ZipFile(inputFile));
    }

    public static File createEmptySlot(String prefix, @CheckForNull String suffix) throws IOException {
        File temp = File.createTempFile(prefix, suffix);
        if (!temp.delete()) {
            throw new IOException(String.format("Cannot delete temporary file %s .", temp));
        }
        return temp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loanTempFileTo(String prefix, @CheckForNull String suffix, FileTask task) throws Exception {
        File temp = File.createTempFile(prefix, suffix);
        Exception ex = null;
        try {
            task.execute(temp);
            if (temp.delete() || null != ex) return;
        }
        catch (Exception ex2) {
            try {
                ex = ex2;
                throw ex;
            }
            catch (Throwable throwable) {
                if (temp.delete() || null != ex) throw throwable;
                throw new IOException(String.format("Cannot delete temporary file %s .", temp));
            }
        }
        throw new IOException(String.format("Cannot delete temporary file %s .", temp));
    }

    public static interface FileTask {
        public void execute(File var1) throws Exception;
    }
}

