/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.plug.openejb;

import java.io.File;
import java.io.IOException;
import net.java.trueupdate.manager.plug.openejb.Command;

final class RenameFileCommand
implements Command {
    private final File from;
    private final File to;

    RenameFileCommand(File from, File to) {
        assert (null != from);
        this.from = from;
        assert (null != to);
        this.to = to;
    }

    @Override
    public void execute() throws Exception {
        if (!this.from.renameTo(this.to)) {
            throw this.ioException(this.from, this.to);
        }
    }

    @Override
    public void revert() throws Exception {
        if (!this.to.renameTo(this.from)) {
            throw this.ioException(this.to, this.from);
        }
    }

    private IOException ioException(File from, File to) {
        return new IOException(String.format("Cannot rename file %s to file %s .", from, to));
    }
}

