/*
 * Decompiled with CFR 0.152.
 */
package net.imknown.bettertextclockbackportlibrary;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.ViewDebug;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.util.Calendar;
import java.util.TimeZone;
import net.imknown.bettertextclockbackportlibrary.DateFormatCompat;
import net.imknown.bettertextclockbackportlibrary.R;
import net.imknown.bettertextclockbackportlibrary.RemotableViewMethod;

@RemoteViews.RemoteView
public class TextClock
extends TextView {
    public static final CharSequence DEFAULT_FORMAT_12_HOUR = "h:mm a";
    public static final CharSequence DEFAULT_FORMAT_24_HOUR = "H:mm";
    private CharSequence mFormat12;
    private CharSequence mFormat24;
    private CharSequence mDescFormat12;
    private CharSequence mDescFormat24;
    @ViewDebug.ExportedProperty
    private CharSequence mFormat;
    @ViewDebug.ExportedProperty
    private boolean mHasSeconds;
    private CharSequence mDescFormat;
    private boolean mAttached;
    private Calendar mTime;
    private String mTimeZone;
    public static final int FORMAT_12 = 0;
    public static final int FORMAT_24 = 1;
    public static final int FORMAT_AUTO = 2;
    private int forceUse = 2;
    private static final CharSequence LocaleData_timeFormat_hm = "h:mm";
    private static final CharSequence LocaleData_timeFormat_kkm = "kk:mm";
    private final ContentObserver mFormatChangeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }

        public void onChange(boolean selfChange, Uri uri) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }
    };
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (TextClock.this.mTimeZone == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                String timeZone = intent.getStringExtra("time-zone");
                TextClock.this.createTime(timeZone);
            }
            TextClock.this.onTimeChanged();
        }
    };
    private final Runnable mTicker = new Runnable(){

        @Override
        public void run() {
            TextClock.this.onTimeChanged();
            long now = SystemClock.uptimeMillis();
            long next = now + (1000L - now % 1000L);
            TextClock.this.getHandler().postAtTime(TextClock.this.mTicker, next);
        }
    };

    public TextClock(Context context) {
        super(context);
        this.init();
    }

    public TextClock(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClock(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextClock, defStyleAttr, 0);
        try {
            this.mFormat12 = a.getText(R.styleable.TextClock_format12Hour);
            this.mFormat24 = a.getText(R.styleable.TextClock_format24Hour);
            this.mTimeZone = a.getString(R.styleable.TextClock_timeZone);
            this.forceUse = a.getInt(R.styleable.TextClock_forceUse, 2);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        if (this.mFormat12 == null || this.mFormat24 == null) {
            if (this.mFormat12 == null) {
                this.mFormat12 = LocaleData_timeFormat_hm;
            }
            if (this.mFormat24 == null) {
                this.mFormat24 = LocaleData_timeFormat_kkm;
            }
        }
        this.createTime(this.mTimeZone);
        this.chooseFormat(false);
    }

    private void createTime(String timeZone) {
        this.mTime = timeZone != null ? Calendar.getInstance(TimeZone.getTimeZone(timeZone)) : Calendar.getInstance();
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat12Hour() {
        return this.mFormat12;
    }

    @RemotableViewMethod
    public void setFormat12Hour(CharSequence format) {
        this.mFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setContentDescriptionFormat12Hour(CharSequence format) {
        this.mDescFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat24Hour() {
        return this.mFormat24;
    }

    @RemotableViewMethod
    public void setFormat24Hour(CharSequence format) {
        this.mFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setContentDescriptionFormat24Hour(CharSequence format) {
        this.mDescFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public int getForceUse() {
        return this.forceUse;
    }

    public void setForceUse(int forceUse) {
        this.forceUse = forceUse;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public boolean is24HourModeEnabled() {
        if (this.forceUse == 0) {
            return false;
        }
        if (this.forceUse == 1) {
            return true;
        }
        return DateFormat.is24HourFormat((Context)this.getContext());
    }

    public String getTimeZone() {
        return this.mTimeZone;
    }

    @RemotableViewMethod
    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
        this.createTime(timeZone);
        this.onTimeChanged();
    }

    private void chooseFormat() {
        this.chooseFormat(true);
    }

    public CharSequence getFormat() {
        return this.mFormat;
    }

    private void chooseFormat(boolean handleTicker) {
        boolean format24Requested = this.is24HourModeEnabled();
        if (format24Requested) {
            this.mFormat = TextClock.abc(this.mFormat24, this.mFormat12, LocaleData_timeFormat_kkm);
            this.mDescFormat = TextClock.abc(this.mDescFormat24, this.mDescFormat12, this.mFormat);
        } else {
            this.mFormat = TextClock.abc(this.mFormat12, this.mFormat24, LocaleData_timeFormat_hm);
            this.mDescFormat = TextClock.abc(this.mDescFormat12, this.mDescFormat24, this.mFormat);
        }
        boolean hadSeconds = this.mHasSeconds;
        this.mHasSeconds = DateFormatCompat.hasSeconds(this.mFormat);
        if (handleTicker && this.mAttached && hadSeconds != this.mHasSeconds) {
            if (hadSeconds) {
                this.getHandler().removeCallbacks(this.mTicker);
            } else {
                this.mTicker.run();
            }
        }
    }

    private static CharSequence abc(CharSequence a, CharSequence b, CharSequence c) {
        return a == null ? (b == null ? c : b) : a;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            this.registerReceiver();
            this.registerObserver();
            this.createTime(this.mTimeZone);
            if (this.mHasSeconds) {
                this.mTicker.run();
            } else {
                this.onTimeChanged();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.unregisterReceiver();
            this.unregisterObserver();
            this.getHandler().removeCallbacks(this.mTicker);
            this.mAttached = false;
        }
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.getHandler());
    }

    private void registerObserver() {
        ContentResolver resolver = this.getContext().getContentResolver();
        resolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
    }

    private void unregisterReceiver() {
        this.getContext().unregisterReceiver(this.mIntentReceiver);
    }

    private void unregisterObserver() {
        ContentResolver resolver = this.getContext().getContentResolver();
        resolver.unregisterContentObserver(this.mFormatChangeObserver);
    }

    private void onTimeChanged() {
        this.mTime.setTimeInMillis(System.currentTimeMillis());
        this.setText(DateFormat.format((CharSequence)this.mFormat, (Calendar)this.mTime));
        this.setContentDescription(DateFormat.format((CharSequence)this.mDescFormat, (Calendar)this.mTime));
    }
}

