/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;

final class StreamEncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private boolean definitive = true;
    private boolean documentSpecifiedEncodingPossible = true;
    private static final String UTF_16 = "UTF-16";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String EBCDIC = "Cp037";
    private static final String SCSU = "SCSU";
    private static final String UTF_7 = "UTF-7";
    private static final String UTF_EBCDIC = "UTF-EBCDIC";
    private static final String BOCU_1 = "BOCU-1";
    private static final String UTF_32 = "UTF-32";
    private static final String UTF_32BE = "UTF-32BE";
    private static final String UTF_32LE = "UTF-32LE";

    public StreamEncodingDetector(URLConnection urlConnection) throws IOException {
        HttpURLConnection httpURLConnection = urlConnection instanceof HttpURLConnection ? (HttpURLConnection)urlConnection : null;
        InputStream urlInputStream = urlConnection.getInputStream();
        String contentType = urlConnection.getContentType();
        if (contentType != null) {
            this.encoding = Source.getCharsetParameterFromHttpHeaderValue(contentType);
            if (this.encoding != null) {
                this.inputStream = urlInputStream;
                this.encodingSpecificationInfo = "HTTP header Content-Type: " + contentType;
                return;
            }
        }
        this.inputStream = urlInputStream.markSupported() ? urlInputStream : new BufferedInputStream(urlInputStream);
        this.init();
    }

    public StreamEncodingDetector(InputStream inputStream) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.init();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public boolean isDifinitive() {
        return this.definitive;
    }

    public boolean isDocumentSpecifiedEncodingPossible() {
        return this.documentSpecifiedEncodingPossible;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + " - " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String encoding, String encodingSpecificationInfo) {
        this.encoding = encoding;
        this.encodingSpecificationInfo = encodingSpecificationInfo;
        return true;
    }

    private boolean init() throws IOException {
        this.inputStream.mark(4);
        int b1 = this.inputStream.read();
        if (b1 == -1) {
            return this.setEncoding(null, "empty input stream");
        }
        int b2 = this.inputStream.read();
        int b3 = this.inputStream.read();
        int b4 = this.inputStream.read();
        this.inputStream.reset();
        if (b1 == 239) {
            if (b2 == 187 && b3 == 191) {
                return this.setEncoding(UTF_8, "UTF-8 Byte Order Mark (EF BB BF)");
            }
        } else if (b1 == 254) {
            if (b2 == 255) {
                return this.setEncoding(UTF_16, "UTF-16 big-endian Byte Order Mark (FE FF)");
            }
        } else if (b1 == 255) {
            if (b2 == 254) {
                if (b3 == 0 && b4 == 0) {
                    return this.setEncoding(UTF_32, "UTF-32 little-endian Byte Order Mark (FF EE 00 00)");
                }
                return this.setEncoding(UTF_16, "UTF-16 little-endian Byte Order Mark (FF EE)");
            }
        } else if (b1 == 0) {
            if (b2 == 0 && b3 == 254 && b4 == 255) {
                return this.setEncoding(UTF_32, "UTF-32 big-endian Byte Order Mark (00 00 FE FF)");
            }
        } else if (b1 == 14) {
            if (b2 == 254 && b3 == 255) {
                return this.setEncoding(SCSU, "SCSU Byte Order Mark (0E FE FF)");
            }
        } else if (b1 == 43) {
            if (b2 == 47 && b3 == 118) {
                return this.setEncoding(UTF_7, "UTF-7 Byte Order Mark (2B 2F 76)");
            }
        } else if (b1 == 221) {
            if (b2 == 115 && b3 == 102 && b4 == 115) {
                return this.setEncoding(UTF_EBCDIC, "UTF-EBCDIC Byte Order Mark (DD 73 66 73)");
            }
        } else if (b1 == 251 && b2 == 238 && b3 == 40) {
            return this.setEncoding(BOCU_1, "BOCU-1 Byte Order Mark (FB EE 28)");
        }
        this.definitive = false;
        if (b4 == -1) {
            this.documentSpecifiedEncodingPossible = false;
            if (b2 == -1 || b3 != -1) {
                return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (stream 3 bytes long)");
            }
            if (b1 == 0) {
                return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00, stream 2 bytes long)");
            }
            if (b2 == 0) {
                return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream pattern XX 00, stream 2 bytes long)");
            }
            return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (no 00 bytes present, stream 2 bytes long)");
        }
        if (b1 == 0) {
            if (b2 == 0) {
                return this.setEncoding(UTF_32BE, "default 32-bit BE encoding (byte stream starts with 00 00)");
            }
            return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00)");
        }
        if (b4 == 0) {
            if (b3 == 0) {
                return this.setEncoding(UTF_32LE, "default 32-bit LE encoding (byte stream starts with pattern XX ?? 00 00)");
            }
            return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream stars with pattern XX ?? XX 00)");
        }
        if (b2 == 0) {
            return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream starts with pattern XX 00 ?? XX)");
        }
        if (b3 == 0) {
            return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with pattern XX XX 00 XX)");
        }
        if (b1 == 76) {
            if (b2 == 111 && b3 == 167 && b4 == 148) {
                return this.setEncoding(EBCDIC, "default EBCDIC encoding (<?xml...> detected)");
            }
            if (b2 == 90 && b3 == 196 && b4 == 214) {
                return this.setEncoding(EBCDIC, "default EBCDIC encoding (<!DOCTYPE...> detected)");
            }
            if ((b2 & b3 & b4 & 0x80) != 0) {
                return this.setEncoding(EBCDIC, "default EBCDIC-compatible encoding (HTML element detected)");
            }
        }
        return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (no 00 bytes present in first four bytes of stream)");
    }
}

