/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.AttributesOutputSegment;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharOutputSegment;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.RemoveOutputSegment;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StringOutputSegment;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.sourceText = source;
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(Segment segment) {
        this.register(new RemoveOutputSegment(segment));
    }

    public void remove(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove((Segment)iterator.next());
        }
    }

    public void insert(int n, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n, charSequence));
    }

    public void replace(Segment segment, CharSequence charSequence) {
        this.replace(segment.getBegin(), segment.getEnd(), charSequence);
    }

    public void replace(int n, int n2, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n2, charSequence));
    }

    public void replace(int n, int n2, char c) {
        this.register(new CharOutputSegment(n, n2, c));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map replace(Attributes attributes, boolean bl) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, bl);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int n, int n2) {
        this.register(new BlankOutputSegment(n, n2));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, 0, this.sourceText.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer, int n, int n2) throws IOException {
        try {
            if (this.outputSegments.isEmpty()) {
                Util.appendTo(writer, this.sourceText, n, n2);
                return;
            }
            int n3 = n;
            Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
            Iterator iterator = ((AbstractList)this.outputSegments).iterator();
            while (iterator.hasNext()) {
                OutputSegment outputSegment = (OutputSegment)iterator.next();
                if (outputSegment.getEnd() < n3 || outputSegment.getEnd() == n3 && outputSegment.getBegin() < n3) continue;
                if (outputSegment.getBegin() > n2 || outputSegment.getBegin() == n2 && outputSegment.getEnd() > n2) break;
                if (outputSegment.getBegin() > n3) {
                    Util.appendTo(writer, this.sourceText, n3, outputSegment.getBegin());
                }
                if (outputSegment.getBegin() < n3 && outputSegment instanceof BlankOutputSegment) {
                    int n4 = outputSegment.getEnd();
                    while (n3 < n4) {
                        writer.write(32);
                        ++n3;
                    }
                    continue;
                }
                outputSegment.writeTo(writer);
                n3 = outputSegment.getEnd();
            }
            if (n3 < n2) {
                Util.appendTo(writer, this.sourceText, n3, n2);
            }
        }
        finally {
            writer.flush();
        }
    }

    public long getEstimatedMaximumOutputLength() {
        long l = this.sourceText.length();
        Iterator iterator = ((AbstractList)this.outputSegments).iterator();
        while (iterator.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)iterator.next();
            int n = outputSegment.getEnd() - outputSegment.getBegin();
            l += outputSegment.getEstimatedMaximumOutputLength() - (long)n;
        }
        return l >= 0L ? l : -1L;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getRegisteredOutputSegments().iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            OutputSegment outputSegment = (OutputSegment)iterator.next();
            if (outputSegment instanceof BlankOutputSegment) {
                stringBuffer.append("Replace with Spaces: ");
            } else if (outputSegment instanceof RemoveOutputSegment) {
                stringBuffer.append("Remove: ");
            } else {
                stringBuffer.append("Replace: ");
            }
            if (this.sourceText instanceof Source) {
                charSequence = (Source)this.sourceText;
                stringBuffer.append('(');
                ((Source)charSequence).getRowColumnVector(outputSegment.getBegin()).appendTo(stringBuffer);
                stringBuffer.append('-');
                ((Source)charSequence).getRowColumnVector(outputSegment.getEnd()).appendTo(stringBuffer);
                stringBuffer.append(')');
            } else {
                stringBuffer.append("(p").append(outputSegment.getBegin()).append("-p").append(outputSegment.getEnd()).append(')');
            }
            stringBuffer.append(' ');
            charSequence = ((Object)outputSegment).toString();
            if (((String)charSequence).length() <= 20) {
                stringBuffer.append((String)charSequence);
            } else {
                stringBuffer.append(((String)charSequence).substring(0, 20)).append("...");
            }
            stringBuffer.append(Config.NewLine);
        }
        return stringBuffer.toString();
    }

    public List getRegisteredOutputSegments() {
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        return this.outputSegments;
    }
}

