/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.OutputDocument;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FormFields
extends AbstractCollection {
    private final LinkedHashMap map = new LinkedHashMap();
    private final ArrayList formControls = new ArrayList();
    private Column[] columns = null;

    public FormFields(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FormControl formControl = (FormControl)iterator.next();
            if (formControl.getName() == null || formControl.getName().length() == 0) continue;
            formControl.addToFormFields(this);
            this.formControls.add(formControl);
        }
    }

    public int getCount() {
        return this.map.size();
    }

    public int size() {
        return this.getCount();
    }

    public FormField get(String string) {
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            string = string.toLowerCase();
        }
        return (FormField)this.map.get(string);
    }

    public Iterator iterator() {
        return ((HashMap)this.map).values().iterator();
    }

    public List getValues(String string) {
        FormField formField = this.get(string);
        return formField == null ? null : formField.getValues();
    }

    public Map getDataSet() {
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>((int)((double)this.getCount() / 0.7));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FormField formField = (FormField)iterator.next();
            List list = formField.getValues();
            if (list.isEmpty()) continue;
            String[] stringArray = new String[list.size()];
            Iterator iterator2 = list.iterator();
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = iterator2.next().toString();
            }
            linkedHashMap.put(formField.getName(), stringArray);
        }
        return linkedHashMap;
    }

    public void clearValues() {
        Iterator iterator = ((AbstractList)this.formControls).iterator();
        while (iterator.hasNext()) {
            ((FormControl)iterator.next()).clearValues();
        }
    }

    public void setDataSet(Map map) {
        this.clearValues();
        if (this.map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = entry.getKey().toString();
            FormField formField = this.get(string);
            if (formField == null) continue;
            if (entry.getValue() instanceof Collection) {
                formField.addValues((Collection)entry.getValue());
                continue;
            }
            formField.addValues((CharSequence[])entry.getValue());
        }
    }

    public boolean setValue(String string, CharSequence charSequence) {
        FormField formField = this.get(string);
        return formField == null ? false : formField.setValue(charSequence);
    }

    public boolean addValue(String string, CharSequence charSequence) {
        FormField formField = this.get(string);
        return formField == null ? false : formField.addValue(charSequence);
    }

    public String[] getColumnLabels() {
        this.initColumns();
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            String string = column.formField.getFirstFormControl().getName();
            stringArray[i] = column.predefinedValue != null ? string + '.' + column.predefinedValue : string;
        }
        return stringArray;
    }

    public String[] getColumnValues(Map map) {
        this.initColumns();
        String[] stringArray = new String[this.columns.length];
        if (Config.ColumnValueFalse != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].isBoolean) continue;
                stringArray[i] = Config.ColumnValueFalse;
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = entry.getKey().toString();
            FormField formField = this.get(string);
            if (formField == null) continue;
            List<CharSequence> list = entry.getValue() instanceof Collection ? (List<CharSequence>)entry.getValue() : Arrays.asList((CharSequence[])entry.getValue());
            int n = formField.columnIndex;
            Iterator iterator2 = list.iterator();
            block2: while (iterator2.hasNext()) {
                String string2 = iterator2.next().toString();
                for (int i = n; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    if (column.formField != formField) continue block2;
                    if (column.predefinedValue != null) {
                        if (!column.predefinedValue.equals(string2)) continue;
                        stringArray[i] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (column.isBoolean) {
                        if (string2 == null) continue block2;
                        stringArray[i] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (stringArray[i] == null) {
                        stringArray[i] = string2;
                        continue block2;
                    }
                    stringArray[i] = stringArray[i] + Config.ColumnMultipleValueSeparator + string2;
                    continue block2;
                }
            }
        }
        return stringArray;
    }

    public String[] getColumnValues() {
        return this.getColumnValues(this.getDataSet());
    }

    private void initColumns() {
        if (this.columns != null) {
            return;
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FormField formField = (FormField)iterator.next();
            formField.columnIndex = arrayList.size();
            if (!formField.allowsMultipleValues() || formField.getPredefinedValues().isEmpty()) {
                arrayList.add(new Column(formField, formField.getPredefinedValues().size() == 1, null));
                continue;
            }
            Iterator iterator2 = formField.getPredefinedValues().iterator();
            while (iterator2.hasNext()) {
                arrayList.add(new Column(formField, true, (String)iterator2.next()));
            }
            if (formField.getUserValueCount() <= 0) continue;
            arrayList.add(new Column(formField, false, null));
        }
        this.columns = arrayList.toArray(new Column[arrayList.size()]);
    }

    public List getFormControls() {
        return this.formControls;
    }

    public void merge(FormFields formFields) {
        Iterator iterator = formFields.iterator();
        while (iterator.hasNext()) {
            FormField formField = (FormField)iterator.next();
            String string = formField.getName();
            FormField formField2 = this.get(string);
            if (formField2 == null) {
                this.add(formField);
                continue;
            }
            formField2.merge(formField);
        }
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    void add(FormControl formControl) {
        this.add(formControl, formControl.getPredefinedValue());
    }

    void add(FormControl formControl, String string) {
        this.add(formControl, string, formControl.name);
    }

    void addName(FormControl formControl, String string) {
        this.add(formControl, null, string);
    }

    void add(FormControl formControl, String string, String string2) {
        FormField formField;
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            string2 = string2.toLowerCase();
        }
        if ((formField = (FormField)this.map.get(string2)) == null) {
            formField = new FormField(string2);
            this.add(formField);
        }
        formField.addFormControl(formControl, string);
    }

    void replaceInOutputDocument(OutputDocument outputDocument) {
        Iterator iterator = ((AbstractList)this.formControls).iterator();
        while (iterator.hasNext()) {
            outputDocument.replace((FormControl)iterator.next());
        }
    }

    private void add(FormField formField) {
        this.map.put(formField.getName(), formField);
    }

    private static class Column {
        public FormField formField;
        public boolean isBoolean;
        public String predefinedValue;

        public Column(FormField formField, boolean bl, String string) {
            this.formField = formField;
            this.isBoolean = bl;
            this.predefinedValue = string;
        }
    }
}

