/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Logger;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StreamEncodingDetector;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;

final class EncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private final String preliminaryEncoding;
    private final String preliminaryEncodingSpecificationInfo;
    private final String alternativePreliminaryEncoding;
    private static final int PREVIEW_BYTE_COUNT = 2048;
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";

    public EncodingDetector(URL url) throws IOException {
        this(new StreamEncodingDetector(url));
    }

    public EncodingDetector(InputStream inputStream) throws IOException {
        this(new StreamEncodingDetector(inputStream));
    }

    public EncodingDetector(InputStream inputStream, String preliminaryEncoding) throws IOException {
        this(inputStream, preliminaryEncoding, "preliminary encoding set explicitly", null);
        if (!Charset.isSupported(preliminaryEncoding)) {
            throw new UnsupportedEncodingException(preliminaryEncoding + " specified as preliminaryEncoding constructor argument");
        }
        this.detectDocumentSpecifiedEncoding();
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector) throws IOException {
        this(streamEncodingDetector, ISO_8859_1);
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector, String alternativePreliminaryEncoding) throws IOException {
        this(streamEncodingDetector.getInputStream(), streamEncodingDetector.getEncoding(), streamEncodingDetector.getEncodingSpecificationInfo(), alternativePreliminaryEncoding);
        if (streamEncodingDetector.isDifinitive() || !streamEncodingDetector.isDocumentSpecifiedEncodingPossible()) {
            this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo);
        } else {
            this.detectDocumentSpecifiedEncoding();
        }
    }

    private EncodingDetector(InputStream inputStream, String preliminaryEncoding, String preliminaryEncodingSpecificationInfo, String alternativePreliminaryEncoding) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.preliminaryEncoding = preliminaryEncoding;
        this.preliminaryEncodingSpecificationInfo = preliminaryEncodingSpecificationInfo;
        this.alternativePreliminaryEncoding = alternativePreliminaryEncoding;
        if (alternativePreliminaryEncoding != null && !Charset.isSupported(alternativePreliminaryEncoding)) {
            throw new UnsupportedEncodingException(alternativePreliminaryEncoding + " specified as alternativePreliminaryEncoding constructor argument");
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncoding() {
        return this.preliminaryEncoding;
    }

    public String getPreliminaryEncodingSpecificationInfo() {
        return this.preliminaryEncodingSpecificationInfo;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + ": " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String encoding, String encodingSpecificationInfo) {
        this.encoding = encoding;
        this.encodingSpecificationInfo = encodingSpecificationInfo;
        return true;
    }

    private boolean detectDocumentSpecifiedEncoding() throws IOException {
        String documentSpecifiedEncodingInfoSuffix;
        String safePreliminaryEncoding;
        this.inputStream.mark(2048);
        if (Charset.isSupported(this.preliminaryEncoding)) {
            safePreliminaryEncoding = this.preliminaryEncoding;
        } else {
            if (this.alternativePreliminaryEncoding == null) {
                throw new UnsupportedEncodingException(this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
            }
            safePreliminaryEncoding = this.alternativePreliminaryEncoding;
        }
        Source previewSource = this.getPreviewSource(safePreliminaryEncoding);
        this.inputStream.reset();
        Logger logger = previewSource.getLogger();
        previewSource.setLogger(null);
        if (this.preliminaryEncoding != safePreliminaryEncoding && logger.isWarnEnabled()) {
            logger.warn("Alternative encoding " + safePreliminaryEncoding + " substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
        }
        if (previewSource.getDocumentSpecifiedEncoding() == null) {
            if (previewSource.isXML()) {
                return this.setEncoding(UTF_8, "mandatory XML encoding when no BOM or encoding declaration is present");
            }
            documentSpecifiedEncodingInfoSuffix = "no encoding specified in document";
        } else {
            if (Charset.isSupported(previewSource.getDocumentSpecifiedEncoding())) {
                return this.setEncoding(previewSource.getDocumentSpecifiedEncoding(), previewSource.getEncodingSpecificationInfo());
            }
            documentSpecifiedEncodingInfoSuffix = "encoding " + previewSource.getDocumentSpecifiedEncoding() + " specified in document is not supported";
            if (logger.isWarnEnabled()) {
                logger.warn("Unsupported encoding " + previewSource.getDocumentSpecifiedEncoding() + " specified in document, using preliminary encoding " + safePreliminaryEncoding + " instead");
            }
        }
        if (this.preliminaryEncoding != safePreliminaryEncoding) {
            return this.setEncoding(safePreliminaryEncoding, "alternative encoding substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo + ", " + documentSpecifiedEncodingInfoSuffix);
        }
        return this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo + ", " + documentSpecifiedEncodingInfoSuffix);
    }

    private Source getPreviewSource(String previewEncoding) throws IOException {
        int nextByte;
        int i;
        byte[] bytes = new byte[2048];
        for (i = 0; i < 2048 && (nextByte = this.inputStream.read()) != -1; ++i) {
            bytes[i] = (byte)nextByte;
        }
        return new Source(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes, 0, i), previewEncoding), null);
    }
}

