/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.MasonTagTypes;
import au.id.jericho.lib.html.PHPTagTypes;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.TagType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Tag
extends Segment
implements HTMLElementName {
    String name = null;
    Element element = Element.NOT_CACHED;
    int allTagsArrayIndex = -1;
    private Object userData = null;
    public static final String PROCESSING_INSTRUCTION = StartTagType.XML_PROCESSING_INSTRUCTION.getNamePrefixForTagConstant();
    public static final String XML_DECLARATION = StartTagType.XML_DECLARATION.getNamePrefixForTagConstant();
    public static final String DOCTYPE_DECLARATION = StartTagType.DOCTYPE_DECLARATION.getNamePrefixForTagConstant();
    public static final String SERVER_PHP = PHPTagTypes.PHP_STANDARD.getNamePrefixForTagConstant();
    public static final String SERVER_COMMON = StartTagType.SERVER_COMMON.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_NAMED_BLOCK = MasonTagTypes.MASON_NAMED_BLOCK.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALL = MasonTagTypes.MASON_COMPONENT_CALL.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALLED_WITH_CONTENT = MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT.getNamePrefixForTagConstant();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int begin, int end, String name) {
        super(source, begin, end);
        this.name = HTMLElements.getConstantElementName(name.toLowerCase());
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int nameSegmentBegin = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, nameSegmentBegin, nameSegmentBegin + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Tag findNextTag() {
        Tag[] allTagsArray = this.source.allTagsArray;
        if (allTagsArray != null) {
            int nextAllTagsArrayIndex = this.allTagsArrayIndex + 1;
            if (allTagsArray.length == nextAllTagsArrayIndex) {
                return null;
            }
            return allTagsArray[nextAllTagsArrayIndex];
        }
        return this.source.findNextTag(this.begin + 1);
    }

    public Tag findPreviousTag() {
        Tag[] allTagsArray = this.source.allTagsArray;
        if (allTagsArray != null) {
            if (this.allTagsArrayIndex == 0) {
                return null;
            }
            return allTagsArray[this.allTagsArrayIndex - 1];
        }
        if (this.begin == 0) {
            return null;
        }
        return this.source.findPreviousTag(this.begin - 1);
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence text) {
        if (text == null || text.length() == 0 || !Tag.isXMLNameStartChar(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Tag.isXMLNameChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == ':';
    }

    public static final boolean isXMLNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    public abstract String regenerateHTML();

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag findPreviousOrNextTag(Source source, int pos, boolean previous) {
        return source.useAllTypesCache ? source.cache.findPreviousOrNextTag(pos, previous) : Tag.findPreviousOrNextTagUncached(source, pos, previous, -1);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int pos, boolean previous, int breakAtPos) {
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            while (true) {
                int n = begin = previous ? parseText.lastIndexOf('<', begin, breakAtPos) : parseText.indexOf('<', begin, breakAtPos);
                if (begin == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin);
                if (tag != null && tag.includeInSearch()) {
                    return tag;
                }
                if (previous) {
                    if (--begin >= 0) {
                        continue;
                    }
                    break;
                }
                if (++begin >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static final Tag findPreviousOrNextTag(Source source, int pos, TagType tagType, boolean previous) {
        if (source.useSpecialTypesCache) {
            return source.cache.findPreviousOrNextTag(pos, tagType, previous);
        }
        return Tag.findPreviousOrNextTagUncached(source, pos, tagType, previous, -1);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int pos, TagType tagType, boolean previous, int breakAtPos) {
        if (tagType == null) {
            return Tag.findPreviousOrNextTagUncached(source, pos, previous, breakAtPos);
        }
        char[] startDelimiterCharArray = tagType.getStartDelimiterCharArray();
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            while (true) {
                int n = begin = previous ? parseText.lastIndexOf(startDelimiterCharArray, begin, breakAtPos) : parseText.indexOf(startDelimiterCharArray, begin, breakAtPos);
                if (begin == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin);
                if (tag != null && tag.getTagType() == tagType) {
                    return tag;
                }
                if (previous) {
                    if (--begin >= 0) {
                        continue;
                    }
                    break;
                }
                if (++begin >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int pos) {
        return source.useAllTypesCache ? source.cache.getTagAt(pos) : Tag.getTagAtUncached(source, pos);
    }

    static final Tag getTagAtUncached(Source source, int pos) {
        return TagType.getTagAt(source, pos, false);
    }

    static final Tag[] parseAll(Source source, boolean assumeNoNestedTags) {
        int registeredTagCount = 0;
        int registeredStartTagCount = 0;
        ArrayList<Tag> list = new ArrayList<Tag>();
        if (source.end != 0) {
            ParseText parseText = source.getParseText();
            Tag tag = Tag.parseAllFindNextTag(source, parseText, 0, assumeNoNestedTags);
            while (tag != null) {
                int pos;
                list.add(tag);
                if (!tag.isUnregistered()) {
                    ++registeredTagCount;
                    if (tag instanceof StartTag) {
                        ++registeredStartTagCount;
                    }
                }
                int n = pos = assumeNoNestedTags && !tag.isUnregistered() ? tag.end : tag.begin + 1;
                if (pos == source.end) break;
                tag = Tag.parseAllFindNextTag(source, parseText, pos, assumeNoNestedTags);
            }
        }
        Tag[] allRegisteredTags = new Tag[registeredTagCount];
        StartTag[] allRegisteredStartTags = new StartTag[registeredStartTagCount];
        source.cache.loadAllTags(list, allRegisteredTags, allRegisteredStartTags);
        source.allTagsArray = allRegisteredTags;
        source.allTags = Arrays.asList(allRegisteredTags);
        source.allStartTags = Arrays.asList(allRegisteredStartTags);
        for (int i = 0; i < allRegisteredTags.length; ++i) {
            allRegisteredTags[i].allTagsArrayIndex = i;
        }
        return allRegisteredTags;
    }

    private static final Tag parseAllFindNextTag(Source source, ParseText parseText, int pos, boolean assumeNoNestedTags) {
        try {
            int begin = pos;
            do {
                if ((begin = parseText.indexOf('<', begin)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source, begin, assumeNoNestedTags);
                if (tag == null) continue;
                if (!assumeNoNestedTags) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source.endOfLastTagIgnoringEnclosedMarkup && !tagType.isServerTag() && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source.endOfLastTagIgnoringEnclosedMarkup = tag.end;
                    }
                }
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static Iterator getNextTagIterator(Source source, int pos) {
        return new NextTagIterator(source, pos);
    }

    private static final class NextTagIterator
    implements Iterator {
        private Tag nextTag = null;

        public NextTagIterator(Source source, int pos) {
            this.nextTag = Tag.findPreviousOrNextTag(source, pos, false);
        }

        public boolean hasNext() {
            return this.nextTag != null;
        }

        public Object next() {
            Tag result = this.nextTag;
            try {
                this.nextTag = Tag.findPreviousOrNextTag(result.source, result.begin + 1, false);
            }
            catch (NullPointerException ex) {
                throw new NoSuchElementException();
            }
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

