/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;

public final class EndTag
extends Tag {
    static final EndTag CACHED_NULL = new EndTag();

    private EndTag() {
    }

    EndTag(Source source, int n, int n2, String string) {
        super(source, n, n2, string);
    }

    public static boolean isForbidden(String string) {
        return EndTag.isEndTagForbidden(string);
    }

    public static boolean isOptional(String string) {
        return EndTag.isEndTagOptional(string);
    }

    public static boolean isRequired(String string) {
        return EndTag.isEndTagRequired(string);
    }

    public static String generateHTML(String string) {
        return "</" + string + ">";
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"/").append(this.name).append("\" ");
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    static EndTag findPreviousOrNext(Source source, int n, String string, boolean bl) {
        String string2 = SearchCache.getEndTagKey(n, string, bl);
        EndTag endTag = source.getSearchCache().getEndTag(string2);
        if (endTag == null) {
            endTag = EndTag.findPreviousOrNextUncached(source, n, string, bl);
            source.getSearchCache().setEndTag(string2, endTag);
        }
        return endTag == CACHED_NULL ? null : endTag;
    }

    private static EndTag findPreviousOrNextUncached(Source source, int n, String string, boolean bl) {
        Segment segment = source.findEnclosingComment(n);
        if (segment != null) {
            n = bl ? segment.begin : segment.end;
        }
        try {
            int n2;
            String string2 = EndTag.generateHTML(string);
            String string3 = source.getParseTextLowerCase();
            int n3 = n2 = bl ? string3.lastIndexOf(string2, n) : string3.indexOf(string2, n);
            if (n2 == -1) {
                return null;
            }
            return new EndTag(source, n2, n2 + string2.length(), string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    static EndTag findNext(Source source, int n) {
        String string = SearchCache.getEndTagKey(n);
        EndTag endTag = source.getSearchCache().getEndTag(string);
        if (endTag == null) {
            endTag = EndTag.findNextUncached(source, n);
            source.getSearchCache().setEndTag(string, endTag);
        }
        return endTag == CACHED_NULL ? null : endTag;
    }

    private static EndTag findNextUncached(Source source, int n) {
        try {
            Segment segment = source.findEnclosingComment(n);
            if (segment != null) {
                return EndTag.findNext(source, segment.end);
            }
            String string = source.getParseTextLowerCase();
            int n2 = string.indexOf("</", n);
            if (n2 == -1) {
                return null;
            }
            int n3 = n2 + 2;
            int n4 = source.getIdentifierEnd(n3, true);
            if (n4 == -1) {
                return EndTag.findNext(source, n3);
            }
            if (string.charAt(n4) != '>') {
                return EndTag.findNext(source, n4);
            }
            String string2 = string.substring(n3, n4);
            return new EndTag(source, n2, n4 + 1, string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }
}

