/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.IOutputSegment;
import au.id.jericho.lib.html.Segment;
import java.io.IOException;
import java.io.Writer;

public final class BlankOutputSegment
implements IOutputSegment {
    private int begin;
    private int end;

    public BlankOutputSegment(int n, int n2) {
        this.begin = n;
        this.end = n2;
    }

    public BlankOutputSegment(Segment segment) {
        this(segment.getBegin(), segment.getEnd());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void output(Writer writer) throws IOException {
        for (int i = this.begin; i < this.end; ++i) {
            writer.write(32);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.end - this.begin);
        for (int i = this.begin; i < this.end; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getDebugInfo() {
        return "(" + this.begin + ',' + this.end + ')';
    }
}

