/*
 * Decompiled with CFR 0.152.
 */
package net.grobas.view.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GeometryUtil {
    public static List<Point> getCircleLineIntersectionPoint(Point pointA, Point pointB, Point center, double radius) {
        double baX = pointB.x - pointA.x;
        double caX = center.x - pointA.x;
        double baY = pointB.y - pointA.y;
        double caY = center.y - pointA.y;
        double bBy2 = baX * caX + baY * caY;
        double a = baX * baX + baY * baY;
        double pBy2 = bBy2 / a;
        double c = caX * caX + caY * caY - radius * radius;
        double q = c / a;
        double disc = pBy2 * pBy2 - q;
        if (disc < 0.0) {
            return Collections.emptyList();
        }
        double tmpSqrt = Math.sqrt(disc);
        double abScalingFactor1 = -pBy2 + tmpSqrt;
        double abScalingFactor2 = -pBy2 - tmpSqrt;
        Point p1 = new Point(pointA.x - baX * abScalingFactor1, pointA.y - baY * abScalingFactor1);
        if (disc == 0.0) {
            return Collections.singletonList(p1);
        }
        Point p2 = new Point(pointA.x - baX * abScalingFactor2, pointA.y - baY * abScalingFactor2);
        return Arrays.asList(p1, p2);
    }

    public static class Point {
        public double x;
        public double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

