/*
 * Decompiled with CFR 0.152.
 */
package net.grobas.shapes;

import android.graphics.Path;
import net.grobas.shapes.PolygonShape;
import net.grobas.shapes.PolygonShapeSpec;

public abstract class BasePolygonShape
implements PolygonShape {
    private Path mPath = new Path();
    private PolygonShapeSpec polygonShapeSpec;

    @Override
    public Path getPolygonPath(PolygonShapeSpec spec) {
        float currentPointX = 0.0f;
        float currentPointY = 0.0f;
        double angleRadians = Math.toRadians(spec.getRotation());
        this.polygonShapeSpec = spec;
        this.mPath.reset();
        int i = 0;
        do {
            float pointX = spec.getCenterX() + spec.getDiameter() / 2.0f * (float)Math.cos(Math.PI * 2 * (double)i / (double)spec.getNumVertex());
            float pointY = spec.getCenterY() + spec.getDiameter() / 2.0f * (float)Math.sin(Math.PI * 2 * (double)i / (double)spec.getNumVertex());
            float rotatedPointX = (float)(Math.cos(angleRadians) * (double)(pointX - spec.getCenterX()) - Math.sin(angleRadians) * (double)(pointY - spec.getCenterY()) + (double)spec.getCenterX());
            float rotatedPointY = (float)(Math.sin(angleRadians) * (double)(pointX - spec.getCenterX()) + Math.cos(angleRadians) * (double)(pointY - spec.getCenterY()) + (double)spec.getCenterY());
            if (i == 0) {
                this.mPath.moveTo(rotatedPointX, rotatedPointY);
            } else {
                this.addEffect(currentPointX, currentPointY, rotatedPointX, rotatedPointY);
            }
            currentPointX = rotatedPointX;
            currentPointY = rotatedPointY;
        } while (++i <= spec.getNumVertex());
        this.mPath.close();
        return this.mPath;
    }

    public Path getPath() {
        return this.mPath;
    }

    public PolygonShapeSpec getPolygonShapeSpec() {
        return this.polygonShapeSpec;
    }

    protected abstract void addEffect(float var1, float var2, float var3, float var4);
}

