/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import net.frju.androidquery.database.ClauseHelper;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class DatabaseProvider {
    protected final Context mContext;
    protected final ClauseHelper mClauseHelper;

    protected DatabaseProvider(@NonNull Context context) {
        this.mContext = context;
        this.mClauseHelper = new ClauseHelper();
    }

    @NonNull
    protected abstract Resolver getResolver();

    @NonNull
    protected abstract String getAuthority();

    @NonNull
    public abstract Uri getUri(@NonNull Class var1, @Nullable String var2);

    @NonNull
    public abstract Uri getUri(@NonNull String var1, @Nullable String var2);

    protected abstract long insert(@NonNull String var1, @NonNull ContentValues var2, @NonNull Query.ConflictResolution var3);

    protected abstract int bulkInsert(@NonNull String var1, @NonNull ContentValues[] var2, @NonNull Query.ConflictResolution var3);

    protected abstract int bulkUpdate(@NonNull String var1, @Nullable String var2, @NonNull ContentValues[] var3, @NonNull Where[][] var4, @NonNull Query.ConflictResolution var5);

    protected abstract Cursor query(@NonNull String var1, @NonNull String[] var2, @Nullable Where[] var3, @Nullable Join[] var4, @Nullable String var5, @Nullable String var6, @Nullable OrderBy[] var7, @Nullable Limit var8);

    protected abstract int delete(@NonNull String var1, @Nullable String var2, @Nullable Where[] var3);

    protected abstract long count(@NonNull String var1, @Nullable Where[] var2);

    @Nullable
    protected abstract Cursor rawQuery(@NonNull String var1);

    @NonNull
    static String firstToUpperCase(@NonNull String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    @NonNull
    static String firstToLowerCase(@NonNull String value) {
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }
}

