/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.support.v4.database;

import android.content.Context;
import android.database.ContentObserver;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import net.frju.androidquery.operation.function.CursorResult;

public abstract class BaseSelectLoader<T>
extends AsyncTaskLoader<CursorResult<T>> {
    private final Loader.ForceLoadContentObserver mObserver = new Loader.ForceLoadContentObserver((Loader)this);
    private CursorResult<T> mCursorResult;

    public BaseSelectLoader(Context context) {
        super(context);
    }

    public CursorResult<T> loadInBackground() {
        CursorResult<T> cursor = this.doSelect();
        if (cursor != null) {
            cursor.getCount();
            cursor.registerContentObserver((ContentObserver)this.mObserver);
        }
        return cursor;
    }

    public void deliverResult(CursorResult<T> data) {
        if (this.isReset()) {
            return;
        }
        this.mCursorResult = data;
        super.deliverResult(data);
    }

    protected void onStartLoading() {
        if (this.mCursorResult != null) {
            this.deliverResult(this.mCursorResult);
        }
        if (this.takeContentChanged() || this.mCursorResult == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        this.mCursorResult = null;
    }

    public abstract CursorResult<T> doSelect();
}

