/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.reactivex.Single;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public class Select
extends Query {
    private final Where[] mWhere;
    private final Join[] mJoins;
    private final OrderBy[] mOrderBy;
    private final Limit mLimit;

    public Where[] getClause() {
        return this.mWhere;
    }

    public Join[] getJoins() {
        return this.mJoins;
    }

    public OrderBy[] getOrderBy() {
        return this.mOrderBy;
    }

    public Limit getLimit() {
        return this.mLimit;
    }

    private Select(Where[] where, Join[] join, OrderBy[] orderBy, Limit limit) {
        this.mWhere = where;
        this.mJoins = join;
        this.mOrderBy = orderBy;
        this.mLimit = limit;
    }

    @NonNull
    public static <T> Builder getBuilder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private Where[] mWhere;
        private Join[] mJoins;
        private OrderBy[] mOrderBy;
        private Limit mLimit;
        private final Class<T> mClassDef;
        private final DatabaseProvider mDatabaseProvider;

        private Builder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> where(Where ... where) {
            this.mWhere = where;
            return this;
        }

        @NonNull
        public Builder<T> join(Join ... joins) {
            this.mJoins = joins;
            return this;
        }

        @NonNull
        public Builder<T> orderByAsc(@NonNull String column) {
            this.addOrderBy(new OrderBy(column, OrderBy.Order.ASC));
            return this;
        }

        @NonNull
        public Builder<T> orderByDesc(@NonNull String column) {
            this.addOrderBy(new OrderBy(column, OrderBy.Order.DESC));
            return this;
        }

        @NonNull
        public Builder<T> orderByAsc(@NonNull String column, @NonNull OrderBy.Collate collate) {
            this.addOrderBy(new OrderBy(column, OrderBy.Order.ASC, collate));
            return this;
        }

        @NonNull
        public Builder<T> orderByDesc(@NonNull String column, @NonNull OrderBy.Collate collate) {
            this.addOrderBy(new OrderBy(column, OrderBy.Order.DESC, collate));
            return this;
        }

        @NonNull
        public Builder<T> orderBy(OrderBy ... orderBy) {
            this.mOrderBy = orderBy;
            return this;
        }

        @NonNull
        public Builder<T> limit(int n) {
            this.mLimit = new Limit(0, n);
            return this;
        }

        @NonNull
        public Builder<T> limit(int start, int end) {
            this.mLimit = new Limit(start, end);
            return this;
        }

        @NonNull
        public CursorResult<T> query() {
            return Select.select(new Select(this.mWhere, this.mJoins, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        @Nullable
        public T queryFirst() {
            return (T)Select.selectFirst(new Select(this.mWhere, this.mJoins, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        @NonNull
        public T[] queryAndInit() {
            return Select.selectAndInit(new Select(this.mWhere, this.mJoins, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        @Nullable
        public T queryFirstAndInit() {
            return (T)Select.selectFirstAndInit(new Select(this.mWhere, this.mJoins, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        @NonNull
        public rx.Single<CursorResult<T>> rx() {
            return Select.wrapRx(new Callable<CursorResult<T>>(){

                @Override
                public CursorResult<T> call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public rx.Single<T[]> rxAndInit() {
            return Select.wrapRx(new Callable<T[]>(){

                @Override
                public T[] call() throws Exception {
                    return Builder.this.queryAndInit();
                }
            });
        }

        @NonNull
        public rx.Single<T> rxFirst() {
            return Select.wrapRx(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.queryFirst();
                }
            });
        }

        @NonNull
        public rx.Single<T> rxFirstAndInit() {
            return Select.wrapRx(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.queryFirstAndInit();
                }
            });
        }

        @NonNull
        public Single<CursorResult<T>> rx2() {
            return Select.wrapRx2(new Callable<CursorResult<T>>(){

                @Override
                public CursorResult<T> call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public Single<T[]> rx2AndInit() {
            return Select.wrapRx2(new Callable<T[]>(){

                @Override
                public T[] call() throws Exception {
                    return Builder.this.queryAndInit();
                }
            });
        }

        @NonNull
        public Single<T> rx2First() {
            return Select.wrapRx2(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.queryFirst();
                }
            });
        }

        @NonNull
        public Single<T> rx2FirstAndInit() {
            return Select.wrapRx2(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.queryFirstAndInit();
                }
            });
        }

        private void addOrderBy(OrderBy orderBy) {
            if (this.mOrderBy == null) {
                this.mOrderBy = new OrderBy[]{orderBy};
            } else {
                this.mOrderBy = Arrays.copyOf(this.mOrderBy, this.mOrderBy.length + 1);
                this.mOrderBy[this.mOrderBy.length - 1] = orderBy;
            }
        }
    }
}

