/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class BaseContentDatabaseProvider
extends DatabaseProvider {
    protected final ContentResolver mContentResolver;

    public BaseContentDatabaseProvider(@NonNull Context context) {
        super(context);
        this.mContentResolver = context.getContentResolver();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull Class model, @Nullable String uriSuffix) {
        String tableDbName = this.getResolver().getDbModelDescriptor(model).getTableDbName();
        if (uriSuffix == null) {
            return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendEncodedPath(BaseContentDatabaseProvider.firstToLowerCase(tableDbName)).build();
        }
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendEncodedPath(BaseContentDatabaseProvider.firstToLowerCase(tableDbName)).appendPath(uriSuffix).build();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull String modelDbName, @Nullable String uriSuffix) {
        if (uriSuffix == null) {
            return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendEncodedPath(BaseContentDatabaseProvider.firstToLowerCase(modelDbName)).build();
        }
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendEncodedPath(BaseContentDatabaseProvider.firstToLowerCase(modelDbName)).appendPath(uriSuffix).build();
    }

    @Override
    protected long insert(@NonNull String tableName, @NonNull ContentValues values, @NonNull Query.ConflictResolution conflictResolution) {
        Uri resultUri = this.mContentResolver.insert(this.getUri(tableName, null), values);
        try {
            return Long.valueOf(resultUri.getLastPathSegment());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    protected int bulkInsert(@NonNull String tableName, @NonNull ContentValues[] valuesArray, @NonNull Query.ConflictResolution conflictResolution) {
        return this.mContentResolver.bulkInsert(this.getUri(tableName, null), valuesArray);
    }

    @Override
    protected int bulkUpdate(@NonNull String tableName, @Nullable String uriSuffix, @NonNull ContentValues[] valuesArray, @NonNull Where[][] conditionsArray, @NonNull Query.ConflictResolution conflictResolution) {
        int nbUpdate = 0;
        for (int i = 0; i < valuesArray.length; ++i) {
            nbUpdate += this.mContentResolver.update(this.getUri(tableName, uriSuffix), valuesArray[i], this.mClauseHelper.getCondition(conditionsArray[i]), this.mClauseHelper.getConditionArgs(conditionsArray[i]));
        }
        return nbUpdate;
    }

    @Override
    @Nullable
    protected Cursor query(@NonNull String tableName, @NonNull String[] columns, @Nullable Where[] where, @Nullable Join[] joins, @Nullable String groupBy, @Nullable String having, @Nullable OrderBy[] orderBy, @Nullable Limit limit) {
        if (joins != null && joins.length > 0) {
            throw new SQLException("Join where not supported by ContentProvider");
        }
        if (groupBy != null) {
            throw new SQLException("GroupBy where not supported by ContentProvider");
        }
        if (having != null) {
            throw new SQLException("Having where not supported by ContentProvider");
        }
        if (limit != null) {
            throw new SQLException("Limit where not supported by ContentProvider");
        }
        return this.mContentResolver.query(this.getUri(tableName, null), columns, this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where), this.mClauseHelper.getOrderBy(orderBy));
    }

    @Override
    protected int delete(@NonNull String tableName, @Nullable String uriSuffix, @Nullable Where[] where) {
        return this.mContentResolver.delete(this.getUri(tableName, uriSuffix), this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where));
    }

    @Override
    protected long count(@NonNull String tableName, @Nullable Where[] where) {
        try (Cursor c = null;){
            c = this.mContentResolver.query(this.getUri(tableName, null), new String[]{"COUNT(*)"}, this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where), null);
            c.moveToFirst();
            long l = c.getLong(0);
            return l;
        }
    }

    @Override
    @Nullable
    protected Cursor rawQuery(@NonNull String sql) {
        throw new SQLException("Raw queries not supported by ContentProvider");
    }
}

