/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.BaseLocalDatabaseProvider;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.ModelListener;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.operation.condition.In;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;
import net.frju.androidquery.operation.keyword.Limit;
import rx.Single;
import rx.SingleSubscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public abstract class Query {
    protected static int save(Save save, Class<?> classDef, DatabaseProvider databaseProvider) {
        int nb = 0;
        DbModelDescriptor table = databaseProvider.getResolver().getDbModelDescriptor(classDef);
        boolean isPrimaryKeyAutoIncrement = table.isPrimaryKeyAutoIncrement();
        ArrayList<Object> modelsToInsert = new ArrayList<Object>();
        for (Object model : save.getModels()) {
            long id = 1L;
            if (isPrimaryKeyAutoIncrement) {
                Object primaryKeyValue = table.getPrimaryKeyValue(model);
                id = Long.parseLong(primaryKeyValue.toString());
            }
            if (id <= 0L || Update.getBuilder(classDef, databaseProvider).model(model).query() <= 0) {
                modelsToInsert.add(model);
                continue;
            }
            ++nb;
        }
        return nb += Insert.getBuilder(databaseProvider, modelsToInsert.toArray()).query();
    }

    protected static int insert(Insert insert, Class<?> classDef, DatabaseProvider databaseProvider) {
        if (insert.getModels() != null && insert.getModels().length > 0) {
            Object[] models = insert.getModels();
            ContentValues[] valuesArray = new ContentValues[models.length];
            DbModelDescriptor dbModelDescriptor = Query.getTableDescription(classDef, databaseProvider);
            for (int i = 0; i < models.length; ++i) {
                if (models[i] instanceof ModelListener) {
                    ((ModelListener)models[i]).onPreInsert();
                }
                valuesArray[i] = dbModelDescriptor.getContentValues(models[i]);
            }
            if (models.length == 1) {
                long newId = databaseProvider.insert(dbModelDescriptor.getTableDbName(), valuesArray[0]);
                if (newId != -1L) {
                    dbModelDescriptor.setIdToModel(models[0], newId);
                    return 1;
                }
                return 0;
            }
            return databaseProvider.bulkInsert(dbModelDescriptor.getTableDbName(), valuesArray);
        }
        return 0;
    }

    protected static Cursor selectCursor(Select select, Class<?> classDef, DatabaseProvider databaseProvider, boolean firstOnly) {
        DbModelDescriptor dbModelDescriptor = Query.getTableDescription(classDef, databaseProvider);
        return databaseProvider.query(dbModelDescriptor.getTableDbName(), select.getJoins() != null ? dbModelDescriptor.getColumnNamesWithTablePrefix() : dbModelDescriptor.getColumnNames(), select.getClause(), select.getJoins(), null, null, select.getOrderBy(), firstOnly && databaseProvider instanceof BaseLocalDatabaseProvider ? new Limit(0, 1) : select.getLimit());
    }

    protected static <T> CursorResult<T> select(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider, false);
        return new CursorResult<T>(classDef, databaseProvider.getResolver(), cursor);
    }

    protected static <T> T[] selectAndInit(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        T[] result;
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider, false);
        Resolver resolver = databaseProvider.getResolver();
        for (T object : result = new CursorResult<T>(classDef, resolver, cursor).toArray()) {
            resolver.initModelWithInitMethods(object);
        }
        return result;
    }

    protected static <T> T selectFirst(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider, true);
        T[] results = Query.getTableDescription(classDef, databaseProvider).getArrayResult(cursor);
        if (results != null && results.length > 0) {
            return results[0];
        }
        return null;
    }

    protected static <T> T selectFirstAndInit(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider, true);
        T[] results = Query.getTableDescription(classDef, databaseProvider).getArrayResult(cursor);
        if (results != null && results.length > 0) {
            databaseProvider.getResolver().initModelWithInitMethods(results[0]);
            return results[0];
        }
        return null;
    }

    protected static int update(Update update, Class<?> classDef, DatabaseProvider databaseProvider) {
        Object[] models = update.getModels();
        if (models != null) {
            DbModelDescriptor tableDesc = Query.getTableDescription(classDef, databaseProvider);
            String primaryKeyName = tableDesc.getPrimaryKeyDbName();
            String uriSuffix = null;
            ContentValues[] valuesArray = new ContentValues[models.length];
            Where[][] conditionsArray = new Where[models.length][];
            for (int i = 0; i < models.length; ++i) {
                Object model = models[i];
                if (models.length == 1) {
                    uriSuffix = Uri.encode((String)tableDesc.getPrimaryKeyValue(model).toString());
                }
                conditionsArray[i] = update.getConditions();
                if (conditionsArray[i] == null) {
                    if (TextUtils.isEmpty((CharSequence)primaryKeyName)) {
                        throw new IllegalStateException("update with model() method require a primary key");
                    }
                    conditionsArray[i] = new Where[1];
                    conditionsArray[i][0] = Where.field(primaryKeyName).isEqualTo(tableDesc.getPrimaryKeyValue(model));
                }
                if (model instanceof ModelListener) {
                    ((ModelListener)model).onPreUpdate();
                }
                valuesArray[i] = tableDesc.getContentValues(model);
            }
            return databaseProvider.bulkUpdate(tableDesc.getTableDbName(), uriSuffix, valuesArray, conditionsArray);
        }
        return databaseProvider.bulkUpdate(Query.getTableDescription(classDef, databaseProvider).getTableDbName(), null, new ContentValues[]{update.getContentValues()}, new Where[][]{update.getConditions()});
    }

    protected static long count(Count count, Class<?> classDef, DatabaseProvider databaseProvider) {
        return databaseProvider.count(Query.getTableDescription(classDef, databaseProvider).getTableDbName(), count.getClause());
    }

    protected static int delete(Delete delete, Class<?> classDef, DatabaseProvider databaseProvider) {
        Object[] models = delete.getModels();
        if (models != null) {
            DbModelDescriptor tableDesc = Query.getTableDescription(classDef, databaseProvider);
            String primaryKeyName = tableDesc.getPrimaryKeyDbName();
            String uriSuffix = null;
            if (TextUtils.isEmpty((CharSequence)primaryKeyName)) {
                throw new IllegalStateException("delete with model() method require a primary key");
            }
            Object[] keys = new String[delete.getModels().length];
            for (int i = 0; i < models.length; ++i) {
                keys[i] = tableDesc.getPrimaryKeyValue(models[i]);
                if (models.length == 1) {
                    uriSuffix = Uri.encode((String)keys[i].toString());
                }
                if (!(models[i] instanceof ModelListener)) continue;
                ((ModelListener)models[i]).onPreDelete();
            }
            In where = Where.field(primaryKeyName).isIn(keys);
            return databaseProvider.delete(tableDesc.getTableDbName(), uriSuffix, new Where[]{where});
        }
        return databaseProvider.delete(Query.getTableDescription(classDef, databaseProvider).getTableDbName(), null, delete.getConditions());
    }

    @Nullable
    protected static Cursor rawQuery(@NonNull String query, @NonNull DatabaseProvider databaseProvider) {
        return databaseProvider.rawQuery(query);
    }

    @NonNull
    protected static <T> rx.Single<T> wrapRx(final @NonNull Callable<T> func) {
        return rx.Single.create((Single.OnSubscribe)new Single.OnSubscribe<T>(){

            public void call(SingleSubscriber<? super T> singleSubscriber) {
                try {
                    singleSubscriber.onSuccess(func.call());
                }
                catch (Exception e) {
                    singleSubscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @NonNull
    protected static <T> Single<T> wrapRx2(final @NonNull Callable<T> func) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(SingleEmitter<T> emitter) throws Exception {
                try {
                    emitter.onSuccess(func.call());
                }
                catch (Exception e) {
                    emitter.onError((Throwable)e);
                }
            }
        }).subscribeOn(io.reactivex.schedulers.Schedulers.io()).observeOn(io.reactivex.android.schedulers.AndroidSchedulers.mainThread());
    }

    private static DbModelDescriptor getTableDescription(Class<?> classDef, DatabaseProvider databaseProvider) {
        return databaseProvider.getResolver().getDbModelDescriptor(classDef);
    }
}

