/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import net.frju.androidquery.database.ClauseHelper;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class DatabaseProvider {
    protected final Context mContext;
    protected final ClauseHelper mClauseHelper;

    protected DatabaseProvider(Context context) {
        this.mContext = context;
        this.mClauseHelper = new ClauseHelper();
    }

    @NonNull
    protected abstract Resolver getResolver();

    @NonNull
    protected abstract String getAuthority();

    @NonNull
    public abstract Uri getUri(@NonNull Class var1);

    @NonNull
    public abstract Uri getUri(@NonNull String var1);

    protected abstract long insert(String var1, ContentValues var2);

    protected abstract int bulkInsert(String var1, ContentValues[] var2);

    protected abstract int bulkUpdate(String var1, ContentValues[] var2, Where[][] var3);

    protected abstract Cursor query(String var1, String[] var2, Where[] var3, Join[] var4, String var5, String var6, OrderBy[] var7, Limit var8);

    protected abstract int delete(String var1, Where[] var2);

    protected abstract long count(String var1, Where[] var2);

    protected abstract Cursor rawQuery(String var1);

    static String firstToUpperCase(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    static String firstToLowerCase(String value) {
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }
}

