/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.support.annotation.NonNull;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class BaseContentDatabaseProvider
extends DatabaseProvider {
    protected final ContentResolver mContentResolver;

    public BaseContentDatabaseProvider(Context context) {
        super(context);
        this.mContentResolver = context.getContentResolver();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull Class model) {
        String tableDbName = this.getResolver().getDbModelDescriptor(model).getTableDbName();
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseContentDatabaseProvider.firstToLowerCase(tableDbName)).build();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull String modelDbName) {
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseContentDatabaseProvider.firstToLowerCase(modelDbName)).build();
    }

    @Override
    protected long insert(String tableName, ContentValues values) {
        Uri resultUri = this.mContentResolver.insert(this.getUri(tableName), values);
        try {
            return Long.valueOf(resultUri.getLastPathSegment());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    protected int bulkInsert(String tableName, ContentValues[] valuesArray) {
        return this.mContentResolver.bulkInsert(this.getUri(tableName), valuesArray);
    }

    @Override
    protected int bulkUpdate(String tableName, ContentValues[] valuesArray, Where[][] conditionsArray) {
        int nbUpdate = 0;
        for (int i = 0; i < valuesArray.length; ++i) {
            nbUpdate += this.mContentResolver.update(this.getUri(tableName), valuesArray[i], this.mClauseHelper.getCondition(conditionsArray[i]), this.mClauseHelper.getConditionArgs(conditionsArray[i]));
        }
        return nbUpdate;
    }

    @Override
    protected Cursor query(String tableName, String[] columns, Where[] where, Join[] joins, String groupBy, String having, OrderBy[] orderBy, Limit limit) {
        if (joins != null && joins.length > 0) {
            throw new SQLException("Join where not supported by ContentProvider");
        }
        if (groupBy != null) {
            throw new SQLException("GroupBy where not supported by ContentProvider");
        }
        if (having != null) {
            throw new SQLException("Having where not supported by ContentProvider");
        }
        if (limit != null) {
            throw new SQLException("Limit where not supported by ContentProvider");
        }
        return this.mContentResolver.query(this.getUri(tableName), columns, this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where), this.mClauseHelper.getOrderBy(orderBy));
    }

    @Override
    protected int delete(String tableName, Where[] where) {
        return this.mContentResolver.delete(this.getUri(tableName), this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where));
    }

    @Override
    protected long count(String tableName, Where[] where) {
        try (Cursor c = null;){
            c = this.mContentResolver.query(this.getUri(tableName), new String[]{"COUNT(*)"}, this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where), null);
            c.moveToFirst();
            long l = c.getLong(0);
            return l;
        }
    }

    @Override
    protected Cursor rawQuery(String sql) {
        throw new SQLException("Raw queries not supported by ContentProvider");
    }
}

