/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import io.reactivex.Single;
import java.util.List;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.condition.Where;

public class Update
extends Query {
    private Object[] mModels;
    private ContentValues mContentValues;
    private Condition[] mConditions;

    public Object[] getModels() {
        return this.mModels;
    }

    public ContentValues getContentValues() {
        return this.mContentValues;
    }

    public Condition[] getConditions() {
        return this.mConditions;
    }

    private Update(Object ... models) {
        this.mModels = models;
    }

    private Update(ContentValues contentValues, Condition[] conditions) {
        this.mContentValues = contentValues;
        this.mConditions = conditions;
    }

    @NonNull
    public static <T> Builder getBuilder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private T[] mModels;
        private ContentValues mValues;
        private Condition[] mCondition;
        private final Class<T> mClassDef;
        private final DatabaseProvider mDatabaseProvider;

        private Builder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        @NonNull
        public Builder<T> where(Where ... clause) {
            this.mCondition = clause;
            return this;
        }

        @SafeVarargs
        @NonNull
        public final Builder<T> model(T ... models) {
            this.mModels = models;
            return this;
        }

        @NonNull
        public Builder<T> model(@NonNull List<T> models) {
            this.mModels = models.toArray(new Object[models.size()]);
            return this;
        }

        @NonNull
        public Builder<T> values(ContentValues values) {
            this.mValues = values;
            return this;
        }

        public int query() {
            if (this.mModels != null) {
                return Update.update(new Update((Object[])this.mModels), this.mClassDef, this.mDatabaseProvider);
            }
            return Update.update(new Update(this.mValues, this.mCondition), this.mClassDef, this.mDatabaseProvider);
        }

        @NonNull
        public rx.Single<Integer> rx() {
            return Update.wrapRx(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public Single<Integer> rx2() {
            return Update.wrapRx2(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.query();
                }
            });
        }
    }
}

