/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;
import rx.Observable;

public class Select
extends Query {
    private final Condition[] mCondition;
    private final Join[] mJoins;
    private final OrderBy[] mOrderBy;
    private final Limit mLimit;

    public Condition[] getClause() {
        return this.mCondition;
    }

    public Join[] getJoins() {
        return this.mJoins;
    }

    public OrderBy[] getOrderBy() {
        return this.mOrderBy;
    }

    public Limit getLimit() {
        return this.mLimit;
    }

    private Select(Condition[] condition, Join[] join, OrderBy[] orderBy, Limit limit) {
        this.mCondition = condition;
        this.mJoins = join;
        this.mOrderBy = orderBy;
        this.mLimit = limit;
    }

    @NonNull
    public static <T> Builder getBuilder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private Condition[] mCondition;
        private Join[] mJoins;
        private OrderBy[] mOrderBy;
        private Limit mLimit;
        private final Class<T> mClassDef;
        private final DatabaseProvider mDatabaseProvider;

        private Builder(@NonNull Class<T> classDef, @NonNull DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> where(Condition ... condition) {
            this.mCondition = condition;
            return this;
        }

        @NonNull
        public Builder<T> join(Join ... joins) {
            this.mJoins = joins;
            return this;
        }

        @NonNull
        public Builder<T> orderBy(@NonNull String column, @NonNull OrderBy.Order order) {
            if (this.mOrderBy == null) {
                this.mOrderBy = new OrderBy[]{new OrderBy(column, order)};
            } else {
                this.mOrderBy = Arrays.copyOf(this.mOrderBy, this.mOrderBy.length + 1);
                this.mOrderBy[this.mOrderBy.length - 1] = new OrderBy(column, order);
            }
            return this;
        }

        @NonNull
        public Builder<T> orderBy(OrderBy ... orderBy) {
            this.mOrderBy = orderBy;
            return this;
        }

        @NonNull
        public Builder<T> limit(int n) {
            this.mLimit = new Limit(0, n);
            return this;
        }

        @NonNull
        public Builder<T> limit(int start, int end) {
            this.mLimit = new Limit(start, end);
            return this;
        }

        @NonNull
        public CursorResult<T> query() {
            return Select.select(new Select(this.mCondition, this.mJoins, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        public T querySingle() {
            return (T)Select.selectSingle(new Select(this.mCondition, this.mJoins, this.mOrderBy, new Limit(0, 1)), this.mClassDef, this.mDatabaseProvider);
        }

        @NonNull
        public Observable<CursorResult<T>> rx() {
            return Select.wrapRx(new Callable<CursorResult<T>>(){

                @Override
                public CursorResult<T> call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public Observable<T> rxSingle() {
            return Select.wrapRx(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.querySingle();
                }
            });
        }

        @NonNull
        public io.reactivex.Observable<CursorResult<T>> rx2() {
            return Select.wrapRx2(new Callable<CursorResult<T>>(){

                @Override
                public CursorResult<T> call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public io.reactivex.Observable<T> rx2Single() {
            return Select.wrapRx2(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.querySingle();
                }
            });
        }
    }
}

