/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.List;
import net.frju.androidquery.database.BaseContentDatabaseProvider;
import net.frju.androidquery.database.BaseLocalDatabaseProvider;

public abstract class BaseContentProvider
extends ContentProvider {
    private SQLiteDatabase mDatabase;

    public String getType(@NonNull Uri uri) {
        try {
            Long.valueOf(uri.getLastPathSegment());
            return "vnd.android.cursor.item/model";
        }
        catch (NumberFormatException e) {
            return "vnd.android.cursor.dir/model";
        }
    }

    public boolean onCreate() {
        this.mDatabase = this.getLocalSQLProvider().getDatabase();
        return true;
    }

    protected abstract BaseLocalDatabaseProvider getLocalSQLProvider();

    protected static String[] getTableRealNameAndSelection(Uri uri, String selection) {
        String tableName;
        String lastSegment = uri.getLastPathSegment();
        try {
            long id = Long.valueOf(lastSegment);
            List segments = uri.getPathSegments();
            tableName = BaseContentDatabaseProvider.firstToUpperCase((String)segments.get(segments.size() - 2));
            String idSelection = "_id=" + id;
            selection = TextUtils.isEmpty((CharSequence)selection) ? idSelection : idSelection + " AND (" + selection + ")";
        }
        catch (NumberFormatException e) {
            tableName = BaseContentDatabaseProvider.firstToUpperCase(uri.getLastPathSegment());
        }
        return new String[]{tableName, selection};
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String[] nameAndSelection = BaseContentProvider.getTableRealNameAndSelection(uri, selection);
        Cursor cursor = this.mDatabase.query(nameAndSelection[0], projection, nameAndSelection[1], selectionArgs, null, null, sortOrder, null);
        if (cursor != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] valuesArray) {
        int nbInsert = 0;
        this.mDatabase.beginTransaction();
        for (ContentValues values : valuesArray) {
            long newId = this.mDatabase.insert(uri.getLastPathSegment(), null, values);
            if (newId <= -1L) continue;
            ++nbInsert;
        }
        this.mDatabase.setTransactionSuccessful();
        this.mDatabase.endTransaction();
        this.getContext().getContentResolver().notifyChange(uri, null);
        return nbInsert;
    }

    public Uri insert(@NonNull Uri uri, ContentValues values) {
        long newId = this.mDatabase.insert(uri.getLastPathSegment(), null, values);
        if (newId > -1L) {
            this.getContext().getContentResolver().notifyChange(uri, null);
            return ContentUris.withAppendedId((Uri)uri, (long)newId);
        }
        throw new SQLException("Could not insert row into " + uri);
    }

    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        String[] nameAndSelection = BaseContentProvider.getTableRealNameAndSelection(uri, selection);
        int count = this.mDatabase.update(nameAndSelection[0], values, nameAndSelection[1], selectionArgs);
        if (count > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return count;
    }

    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        String[] nameAndSelection = BaseContentProvider.getTableRealNameAndSelection(uri, selection);
        int count = this.mDatabase.delete(nameAndSelection[0], nameAndSelection[1], selectionArgs);
        if (count > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return count;
    }
}

