/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class BaseContentDatabaseProvider
extends DatabaseProvider {
    protected final ContentResolver mContentResolver;

    public BaseContentDatabaseProvider(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    protected abstract String getAuthority();

    public Uri getUri(Class model) {
        String tableRealName = this.getResolver().getTableDescription(model).getTableRealName();
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseContentDatabaseProvider.firstToLowerCase(tableRealName)).build();
    }

    protected Uri getUri(String tableName) {
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseContentDatabaseProvider.firstToLowerCase(tableName)).build();
    }

    @Override
    protected long insert(String tableName, ContentValues values) {
        Uri resultUri = this.mContentResolver.insert(this.getUri(tableName), values);
        try {
            return Long.valueOf(resultUri.getLastPathSegment());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    protected int bulkInsert(String tableName, ContentValues[] valuesArray) {
        return this.mContentResolver.bulkInsert(this.getUri(tableName), valuesArray);
    }

    @Override
    protected int bulkUpdate(String tableName, ContentValues[] valuesArray, Condition[][] conditionsArray) {
        int nbUpdate = 0;
        for (int i = 0; i < valuesArray.length; ++i) {
            nbUpdate += this.mContentResolver.update(this.getUri(tableName), valuesArray[i], this.mClauseHelper.getCondition(conditionsArray[i]), this.mClauseHelper.getConditionArgs(conditionsArray[i]));
        }
        return nbUpdate;
    }

    @Override
    protected Cursor query(String tableName, String[] columns, Condition[] condition, Join[] joins, String groupBy, String having, OrderBy[] orderBy, Limit limit) {
        if (joins != null && joins.length > 0) {
            throw new SQLException("Join condition not supported by ContentProvider");
        }
        if (groupBy != null) {
            throw new SQLException("GroupBy condition not supported by ContentProvider");
        }
        if (having != null) {
            throw new SQLException("Having condition not supported by ContentProvider");
        }
        if (limit != null) {
            throw new SQLException("Limit condition not supported by ContentProvider");
        }
        return this.mContentResolver.query(this.getUri(tableName), columns, this.mClauseHelper.getCondition(condition), this.mClauseHelper.getConditionArgs(condition), this.mClauseHelper.getOrderBy(orderBy));
    }

    @Override
    protected int delete(String tableName, Condition[] condition) {
        return this.mContentResolver.delete(this.getUri(tableName), this.mClauseHelper.getCondition(condition), this.mClauseHelper.getConditionArgs(condition));
    }

    @Override
    protected long count(String tableName, Condition[] condition) {
        try (Cursor c = null;){
            c = this.mContentResolver.query(this.getUri(tableName), new String[]{"COUNT(*)"}, this.mClauseHelper.getCondition(condition), this.mClauseHelper.getConditionArgs(condition), null);
            c.moveToFirst();
            long l = c.getLong(0);
            return l;
        }
    }

    @Override
    protected Cursor rawQuery(String sql) {
        throw new SQLException("Raw queries not supported by ContentProvider");
    }

    static String firstToUpperCase(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    static String firstToLowerCase(String value) {
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }
}

