/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.TableDescription;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class BaseLocalDatabaseProvider
extends DatabaseProvider {
    private final SQLiteDatabase mDatabase;
    private final String[] mSchemaArray;
    private final String[][] mColumnsSqlArray;
    private final String[] mTableRealNameArray;
    private final String[] mCreateIndexQuery;
    private final List<String> mIndexNames;

    public BaseLocalDatabaseProvider(Context context) {
        Class<?>[] modelClassDef = this.getResolver().getModelsForProvider(this.getClass());
        int modelCount = modelClassDef.length;
        this.mSchemaArray = new String[modelCount];
        this.mTableRealNameArray = new String[modelCount];
        this.mColumnsSqlArray = new String[modelCount][];
        this.mCreateIndexQuery = new String[modelCount];
        this.mIndexNames = new ArrayList<String>();
        for (int i = 0; i < modelClassDef.length; ++i) {
            TableDescription tableDescription = this.getResolver().getTableDescription(modelClassDef[i]);
            this.mSchemaArray[i] = tableDescription.getTableCreateQuery();
            this.mColumnsSqlArray[i] = tableDescription.getColumnsSqlArray();
            this.mTableRealNameArray[i] = tableDescription.getTableRealName();
            this.mCreateIndexQuery[i] = tableDescription.getCreateIndexQuery();
            Collections.addAll(this.mIndexNames, tableDescription.getIndexNames());
        }
        SQLiteOpenHelper openHelper = new SQLiteOpenHelper(context, this.getDbName(), null, this.getDbVersion()){

            public void onCreate(SQLiteDatabase db) {
                BaseLocalDatabaseProvider.this.onCreate(db);
            }

            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                BaseLocalDatabaseProvider.this.onUpgrade(db, oldVersion, newVersion);
            }
        };
        this.mDatabase = openHelper.getWritableDatabase();
    }

    protected abstract String getDbName();

    protected abstract int getDbVersion();

    protected void onCreate(SQLiteDatabase db) {
        for (String schema : this.mSchemaArray) {
            db.execSQL(schema);
        }
        for (String createIndex : this.mCreateIndexQuery) {
            if (createIndex == null) continue;
            db.execSQL(createIndex);
        }
    }

    protected void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            for (int i = 0; i < this.mTableRealNameArray.length; ++i) {
                String tableName = this.mTableRealNameArray[i];
                for (String columnsSql : this.mColumnsSqlArray[i]) {
                    try {
                        db.execSQL("ALTER TABLE " + tableName + " ADD COLUMN " + columnsSql + ";");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    protected int bulkInsert(String tableName, ContentValues[] valuesArray) {
        int nbInsert = 0;
        this.mDatabase.beginTransaction();
        for (ContentValues values : valuesArray) {
            if (this.mDatabase.insert(tableName, null, values) == -1L) continue;
            ++nbInsert;
        }
        this.mDatabase.setTransactionSuccessful();
        this.mDatabase.endTransaction();
        return nbInsert;
    }

    @Override
    protected int bulkUpdate(String tableName, ContentValues[] valuesArray, Condition[][] conditionsArray) {
        int nbUpdate = 0;
        this.mDatabase.beginTransaction();
        for (int i = 0; i < valuesArray.length; ++i) {
            nbUpdate += this.mDatabase.update(tableName, valuesArray[i], this.mClauseHelper.getCondition(conditionsArray[i]), this.mClauseHelper.getConditionArgs(conditionsArray[i]));
        }
        this.mDatabase.setTransactionSuccessful();
        this.mDatabase.endTransaction();
        return nbUpdate;
    }

    @Override
    protected Cursor query(String tableName, String[] columns, Condition[] condition, Join[] joins, String groupBy, String having, OrderBy[] orderBy, Limit limit) {
        if (joins != null && joins.length > 0) {
            try {
                String joinQuery = this.mClauseHelper.buildJoinQuery(columns, joins, tableName, condition, orderBy, limit, this.getResolver());
                return this.mDatabase.rawQuery(joinQuery, this.mClauseHelper.getConditionArgs(condition));
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        return this.mDatabase.query(tableName, columns, this.mClauseHelper.getCondition(condition), this.mClauseHelper.getConditionArgs(condition), groupBy, having, this.mClauseHelper.getOrderBy(orderBy), this.mClauseHelper.getLimit(limit));
    }

    @Override
    protected int delete(String tableName, Condition[] condition) {
        return this.mDatabase.delete(tableName, this.mClauseHelper.getCondition(condition), this.mClauseHelper.getConditionArgs(condition));
    }

    @Override
    protected long count(String tableName, Condition[] condition) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.mDatabase, (String)tableName, (String)this.mClauseHelper.getCondition(condition), (String[])this.mClauseHelper.getConditionArgs(condition));
    }

    @Override
    protected Cursor rawQuery(String sql) {
        return this.mDatabase.rawQuery(sql, null);
    }

    SQLiteDatabase getDatabase() {
        return this.mDatabase;
    }
}

