/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.content.ContentValues;
import io.reactivex.Observable;
import java.util.List;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.condition.Where;

public class Update
extends Query {
    private Object[] mModels;
    private ContentValues mContentValues;
    private Condition[] mConditions;

    public Object[] getModels() {
        return this.mModels;
    }

    public ContentValues getContentValues() {
        return this.mContentValues;
    }

    public Condition[] getConditions() {
        return this.mConditions;
    }

    private Update(Object ... models) {
        this.mModels = models;
    }

    private Update(ContentValues contentValues, Condition[] conditions) {
        this.mContentValues = contentValues;
        this.mConditions = conditions;
    }

    public static <T> Builder getBuilder(Class<T> classDef, DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private T[] mModels;
        private ContentValues mValues;
        private Condition[] mCondition;
        private Class<T> mClassDef;
        private DatabaseProvider mDatabaseProvider;

        private Builder(Class<T> classDef, DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> where(Where ... clause) {
            this.mCondition = clause;
            return this;
        }

        public Builder<T> model(T ... models) {
            this.mModels = models;
            return this;
        }

        public Builder<T> model(List<T> models) {
            this.mModels = models.toArray(new Object[models.size()]);
            return this;
        }

        public Builder<T> values(ContentValues values) {
            this.mValues = values;
            return this;
        }

        public int query() {
            if (this.mModels != null) {
                return Update.update(new Update((Object[])this.mModels), this.mClassDef, this.mDatabaseProvider);
            }
            return Update.update(new Update(this.mValues, this.mCondition), this.mClassDef, this.mDatabaseProvider);
        }

        public Observable<Integer> rx() {
            return Update.wrapRx(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.query();
                }
            });
        }
    }
}

