/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.AsyncTaskLoader;
import android.content.Context;
import android.content.Loader;
import android.database.ContentObserver;
import net.frju.androidquery.operation.function.Result;

public abstract class BaseSelectLoader<T>
extends AsyncTaskLoader<Result<T>> {
    private final Loader.ForceLoadContentObserver mObserver = new Loader.ForceLoadContentObserver((Loader)this);
    private Result<T> mResult;

    public BaseSelectLoader(Context context) {
        super(context);
    }

    public Result<T> loadInBackground() {
        Result<T> cursor = this.doSelect();
        if (cursor != null) {
            cursor.getCount();
            cursor.registerContentObserver((ContentObserver)this.mObserver);
        }
        return cursor;
    }

    public void deliverResult(Result<T> data) {
        if (this.isReset()) {
            return;
        }
        this.mResult = data;
        super.deliverResult(data);
    }

    protected void onStartLoading() {
        if (this.mResult != null) {
            this.deliverResult(this.mResult);
        }
        if (this.takeContentChanged() || this.mResult == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        this.mResult = null;
    }

    public abstract Result<T> doSelect();
}

