/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.content.ContentValues;
import io.reactivex.Observable;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.clause.Clause;
import net.frju.androidquery.operation.clause.Where;

public class Update
extends Query {
    private Object mModel;
    private ContentValues mContentValues;
    private Clause[] mConditions;

    public Object getModel() {
        return this.mModel;
    }

    public ContentValues getContentValues() {
        return this.mContentValues;
    }

    public Clause[] getConditions() {
        return this.mConditions;
    }

    public Update(Object model) {
        this.mModel = model;
    }

    public Update(ContentValues contentValues, Clause[] conditions) {
        this.mContentValues = contentValues;
        this.mConditions = conditions;
    }

    public static <T> Builder getBuilder(Class<T> classDef, DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private T mModel;
        private ContentValues mValues;
        private Clause[] mClause;
        private Class<T> mClassDef;
        private DatabaseProvider mDatabaseProvider;

        private Builder(Class<T> classDef, DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder where(Where ... clause) {
            this.mClause = clause;
            return this;
        }

        public Builder model(T model) {
            this.mModel = model;
            return this;
        }

        public Builder values(ContentValues values) {
            this.mValues = values;
            return this;
        }

        public int execute() {
            if (this.mModel != null) {
                return Update.update(new Update(this.mModel), this.mClassDef, this.mDatabaseProvider);
            }
            return Update.update(new Update(this.mValues, this.mClause), this.mClassDef, this.mDatabaseProvider);
        }

        public Observable<Integer> rx() {
            return Update.wrapRx(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.execute();
                }
            });
        }
    }
}

