/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.List;
import net.frju.androidquery.converter.UriConverter;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.RawContact;
import net.frju.androidquery.models.gen.Q;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class RAW_CONTACT
implements DbModelDescriptor {
    public static final String ID = "_id";
    public static final String CONTACT_ID = "contact_id";
    public static final String DISPLAY_NAME_PRIMARY = "display_name";
    public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
    public static final String DISPLAY_NAME_SOURCE = "display_name_source";
    public static final String ACCOUNT_NAME = "account_name";
    public static final String ACCOUNT_TYPE = "account_type";
    public static final String TIMES_CONTACTED = "times_contacted";
    public static final String LAST_TIME_CONTACTED = "last_time_contacted";
    public static final String STARRED = "starred";
    public static final String CUSTOM_RINGTONE = "custom_ringtone";

    @NonNull
    public String getTableDbName() {
        return "raw_contacts";
    }

    @NonNull
    public String getTableCreateQuery() {
        return "CREATE TABLE raw_contacts (_id integer PRIMARY KEY AUTOINCREMENT,contact_id integer,display_name text,display_name_alt text,display_name_source text,account_name text,account_type text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text);";
    }

    @NonNull
    public String[] getColumnsSqlArray() {
        return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "contact_id integer", "display_name text", "display_name_alt text", "display_name_source text", "account_name text", "account_type text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text"};
    }

    public String getPrimaryKeyDbName() {
        return ID;
    }

    public String[] getIndexNames() {
        return new String[0];
    }

    public String getCreateIndexQuery() {
        StringBuilder sb = new StringBuilder();
        return sb.length() > 0 ? sb.toString() : null;
    }

    public RawContact getSingleResult(Cursor cursor) {
        if (cursor != null) {
            RawContact rawcontact = new RawContact();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    rawcontact.id = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(CONTACT_ID)) {
                    rawcontact.contactId = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME_PRIMARY)) {
                    rawcontact.displayNamePrimary = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME_ALTERNATIVE)) {
                    rawcontact.displayNameAlternative = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME_SOURCE)) {
                    rawcontact.displayNameSource = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(ACCOUNT_NAME)) {
                    rawcontact.accountName = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(ACCOUNT_TYPE)) {
                    rawcontact.accountType = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                    rawcontact.timesContacted = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                    rawcontact.lastTimeContacted = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(STARRED)) {
                    rawcontact.starred = cursor.getInt(x) > 0;
                    continue;
                }
                if (!cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) continue;
                rawcontact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
            }
            return rawcontact;
        }
        return null;
    }

    public RawContact[] getArrayResult(Cursor cursor) {
        if (cursor != null) {
            RawContact[] result = new RawContact[cursor.getCount()];
            cursor.moveToFirst();
            int i = 0;
            while (!cursor.isAfterLast()) {
                result[i] = this.getSingleResult(cursor);
                cursor.moveToNext();
                ++i;
            }
            cursor.close();
            return result;
        }
        return new RawContact[0];
    }

    public String[] getColumnNames() {
        return new String[]{ID, CONTACT_ID, DISPLAY_NAME_PRIMARY, DISPLAY_NAME_ALTERNATIVE, DISPLAY_NAME_SOURCE, ACCOUNT_NAME, ACCOUNT_TYPE, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE};
    }

    public String[] getColumnNamesWithTablePrefix() {
        return new String[]{"raw_contacts._id", "raw_contacts.contact_id", "raw_contacts.display_name", "raw_contacts.display_name_alt", "raw_contacts.display_name_source", "raw_contacts.account_name", "raw_contacts.account_type", "raw_contacts.times_contacted", "raw_contacts.last_time_contacted", "raw_contacts.starred", "raw_contacts.custom_ringtone"};
    }

    public Object getPrimaryKeyValue(@NonNull Object model) {
        RawContact rawcontact = (RawContact)model;
        return rawcontact.id;
    }

    public void setIdToModel(@NonNull Object model, long id) {
        RawContact rawcontact = (RawContact)model;
        rawcontact.id = id;
    }

    public boolean isPrimaryKeyAutoIncrement() {
        return true;
    }

    @NonNull
    public ContentValues getContentValues(@NonNull Object model) {
        RawContact rawcontact = (RawContact)model;
        ContentValues contentValues = new ContentValues();
        contentValues.put(DISPLAY_NAME_PRIMARY, rawcontact.displayNamePrimary);
        contentValues.put(DISPLAY_NAME_ALTERNATIVE, rawcontact.displayNameAlternative);
        contentValues.put(DISPLAY_NAME_SOURCE, rawcontact.displayNameSource);
        contentValues.put(ACCOUNT_NAME, rawcontact.accountName);
        contentValues.put(ACCOUNT_TYPE, rawcontact.accountType);
        contentValues.put(TIMES_CONTACTED, Integer.valueOf(rawcontact.timesContacted));
        contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(rawcontact.lastTimeContacted));
        contentValues.put(STARRED, Boolean.valueOf(rawcontact.starred));
        contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(rawcontact.customRingtone));
        return contentValues;
    }

    @NonNull
    public static Uri getContentUri() {
        return Q.getResolver().getDatabaseProviderForModel(RawContact.class).getUri(RawContact.class);
    }

    @NonNull
    public static Count.Builder<RawContact> count() {
        return Count.getBuilder(RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class));
    }

    @NonNull
    public static Select.Builder<RawContact> select() {
        return Select.getBuilder(RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class));
    }

    @NonNull
    public static Delete.Builder<RawContact> delete() {
        return Delete.getBuilder(RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class));
    }

    @NonNull
    public static Update.Builder<RawContact> update() {
        return Update.getBuilder(RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class));
    }

    @NonNull
    public static Save.Builder<RawContact> save(RawContact ... models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class), (Object[])models);
    }

    @NonNull
    public static Save.Builder<RawContact> save(@NonNull List<RawContact> models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class), models);
    }

    @NonNull
    public static Insert.Builder<RawContact> insert(RawContact ... models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class), (Object[])models);
    }

    @NonNull
    public static Insert.Builder<RawContact> insert(@NonNull List<RawContact> models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContact.class), models);
    }

    @NonNull
    public static CursorResult<RawContact> fromCursor(Cursor cursor) {
        return new CursorResult(RawContact.class, (Resolver)Q.getResolver(), cursor);
    }
}

