/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.frju.androidquery.converter.UriConverter;
import net.frju.androidquery.database.BaseContentDatabaseProvider;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.BlockedNumberContentDatabaseProvider;
import net.frju.androidquery.models.ContactContentDatabaseProvider;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Raw;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class Q {
    private static DefaultResolver sResolver;
    private static RawContact sRawContact;
    private static BlockedNumber sBlockedNumber;
    private static Contact sContact;

    public static void init(Context context) {
        if (sResolver == null) {
            sResolver = new DefaultResolver();
            sResolver.init(context);
        }
    }

    public static DefaultResolver getResolver() {
        return sResolver;
    }

    static {
        sRawContact = new RawContact();
        sBlockedNumber = new BlockedNumber();
        sContact = new Contact();
    }

    public static class Contact
    implements DbModelDescriptor {
        public static final String ID = "_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PHOTO_URI = "photo_uri";
        public static final String PHOTO_THUMBNAIL_URI = "photo_thumb_uri";
        public static final String TIMES_CONTACTED = "times_contacted";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String LOOKUP_KEY = "lookup";
        public static final String IN_VISIBLE_GROUP = "in_visible_group";
        public static final String HAS_PHONE_NUMBER = "has_phone_number";

        @NonNull
        public String getTableDbName() {
            return "contacts";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE contacts (_id integer PRIMARY KEY AUTOINCREMENT,display_name text,photo_uri text,photo_thumb_uri text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text,lookup text,in_visible_group integer,has_phone_number integer);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "display_name text", "photo_uri text", "photo_thumb_uri text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text", "lookup text", "in_visible_group integer", "has_phone_number integer"};
        }

        public String getPrimaryKeyDbName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.models.Contact getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.Contact contact = new net.frju.androidquery.models.Contact();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        contact.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME)) {
                        contact.displayName = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(PHOTO_URI)) {
                        contact.photoUri = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(PHOTO_THUMBNAIL_URI)) {
                        contact.photoThumbnailUri = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                        contact.timesContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                        contact.lastTimeContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(STARRED)) {
                        contact.starred = cursor.getInt(x) == 1;
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) {
                        contact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LOOKUP_KEY)) {
                        contact.lookupKey = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(IN_VISIBLE_GROUP)) {
                        contact.inVisibleGroup = cursor.getInt(x) == 1;
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(HAS_PHONE_NUMBER)) continue;
                    contact.hasPhoneNumber = cursor.getInt(x) == 1;
                }
                return contact;
            }
            return null;
        }

        public net.frju.androidquery.models.Contact[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.Contact[] result = new net.frju.androidquery.models.Contact[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, DISPLAY_NAME, PHOTO_URI, PHOTO_THUMBNAIL_URI, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE, LOOKUP_KEY, IN_VISIBLE_GROUP, HAS_PHONE_NUMBER};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"contacts._id", "contacts.display_name", "contacts.photo_uri", "contacts.photo_thumb_uri", "contacts.times_contacted", "contacts.last_time_contacted", "contacts.starred", "contacts.custom_ringtone", "contacts.lookup", "contacts.in_visible_group", "contacts.has_phone_number"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.models.Contact contact = (net.frju.androidquery.models.Contact)model;
            return contact.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.models.Contact contact = (net.frju.androidquery.models.Contact)model;
            contact.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.models.Contact contact = (net.frju.androidquery.models.Contact)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(DISPLAY_NAME, contact.displayName);
            contentValues.put(PHOTO_URI, new UriConverter().convertToDb(contact.photoUri));
            contentValues.put(PHOTO_THUMBNAIL_URI, new UriConverter().convertToDb(contact.photoThumbnailUri));
            contentValues.put(TIMES_CONTACTED, Integer.valueOf(contact.timesContacted));
            contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(contact.lastTimeContacted));
            contentValues.put(STARRED, Boolean.valueOf(contact.starred));
            contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(contact.customRingtone));
            contentValues.put(LOOKUP_KEY, new UriConverter().convertToDb(contact.lookupKey));
            contentValues.put(IN_VISIBLE_GROUP, Boolean.valueOf(contact.inVisibleGroup));
            contentValues.put(HAS_PHONE_NUMBER, Boolean.valueOf(contact.hasPhoneNumber));
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class).getUri(net.frju.androidquery.models.Contact.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.models.Contact> count() {
            return Count.getBuilder(net.frju.androidquery.models.Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.models.Contact> select() {
            return Select.getBuilder(net.frju.androidquery.models.Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.models.Contact> delete() {
            return Delete.getBuilder(net.frju.androidquery.models.Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.models.Contact> update() {
            return Update.getBuilder(net.frju.androidquery.models.Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.Contact> save(net.frju.androidquery.models.Contact ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.Contact> save(@NonNull List<net.frju.androidquery.models.Contact> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.Contact> insert(net.frju.androidquery.models.Contact ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.Contact> insert(@NonNull List<net.frju.androidquery.models.Contact> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class), models);
        }

        @NonNull
        public static Raw.Builder raw(@NonNull String query) {
            return Raw.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.Contact.class), (String)query);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.models.Contact> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.models.Contact.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class BlockedNumber
    implements DbModelDescriptor {
        public static final String ID = "_id";
        public static final String E164_NUMBER = "e164_number";
        public static final String ORIGINAL_NUMBER = "original_number";

        @NonNull
        public String getTableDbName() {
            return "blocked";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE blocked (_id integer PRIMARY KEY AUTOINCREMENT,e164_number text,original_number text);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "e164_number text", "original_number text"};
        }

        public String getPrimaryKeyDbName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.models.BlockedNumber getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.BlockedNumber blockednumber = new net.frju.androidquery.models.BlockedNumber();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        blockednumber.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(E164_NUMBER)) {
                        blockednumber.e164Number = cursor.getString(x);
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(ORIGINAL_NUMBER)) continue;
                    blockednumber.originalNumber = cursor.getString(x);
                }
                return blockednumber;
            }
            return null;
        }

        public net.frju.androidquery.models.BlockedNumber[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.BlockedNumber[] result = new net.frju.androidquery.models.BlockedNumber[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, E164_NUMBER, ORIGINAL_NUMBER};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"blocked._id", "blocked.e164_number", "blocked.original_number"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.models.BlockedNumber blockednumber = (net.frju.androidquery.models.BlockedNumber)model;
            return blockednumber.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.models.BlockedNumber blockednumber = (net.frju.androidquery.models.BlockedNumber)model;
            blockednumber.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.models.BlockedNumber blockednumber = (net.frju.androidquery.models.BlockedNumber)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(E164_NUMBER, blockednumber.e164Number);
            contentValues.put(ORIGINAL_NUMBER, blockednumber.originalNumber);
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class).getUri(net.frju.androidquery.models.BlockedNumber.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.models.BlockedNumber> count() {
            return Count.getBuilder(net.frju.androidquery.models.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.models.BlockedNumber> select() {
            return Select.getBuilder(net.frju.androidquery.models.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.models.BlockedNumber> delete() {
            return Delete.getBuilder(net.frju.androidquery.models.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.models.BlockedNumber> update() {
            return Update.getBuilder(net.frju.androidquery.models.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.BlockedNumber> save(net.frju.androidquery.models.BlockedNumber ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.BlockedNumber> save(@NonNull List<net.frju.androidquery.models.BlockedNumber> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.BlockedNumber> insert(net.frju.androidquery.models.BlockedNumber ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.BlockedNumber> insert(@NonNull List<net.frju.androidquery.models.BlockedNumber> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class), models);
        }

        @NonNull
        public static Raw.Builder raw(@NonNull String query) {
            return Raw.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.BlockedNumber.class), (String)query);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.models.BlockedNumber> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.models.BlockedNumber.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class RawContact
    implements DbModelDescriptor {
        public static final String ID = "_id";
        public static final String CONTACT_ID = "contact_id";
        public static final String DISPLAY_NAME_PRIMARY = "display_name";
        public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String TIMES_CONTACTED = "times_contacted";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";

        @NonNull
        public String getTableDbName() {
            return "raw_contacts";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE raw_contacts (_id integer PRIMARY KEY AUTOINCREMENT,contact_id integer,display_name text,display_name_alt text,display_name_source text,account_name text,account_type text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "contact_id integer", "display_name text", "display_name_alt text", "display_name_source text", "account_name text", "account_type text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text"};
        }

        public String getPrimaryKeyDbName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.models.RawContact getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.RawContact rawcontact = new net.frju.androidquery.models.RawContact();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        rawcontact.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(CONTACT_ID)) {
                        rawcontact.contactId = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_PRIMARY)) {
                        rawcontact.displayNamePrimary = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_ALTERNATIVE)) {
                        rawcontact.displayNameAlternative = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_SOURCE)) {
                        rawcontact.displayNameSource = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(ACCOUNT_NAME)) {
                        rawcontact.accountName = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(ACCOUNT_TYPE)) {
                        rawcontact.accountType = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                        rawcontact.timesContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                        rawcontact.lastTimeContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(STARRED)) {
                        rawcontact.starred = cursor.getInt(x) == 1;
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) continue;
                    rawcontact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                }
                return rawcontact;
            }
            return null;
        }

        public net.frju.androidquery.models.RawContact[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.models.RawContact[] result = new net.frju.androidquery.models.RawContact[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, CONTACT_ID, DISPLAY_NAME_PRIMARY, DISPLAY_NAME_ALTERNATIVE, DISPLAY_NAME_SOURCE, ACCOUNT_NAME, ACCOUNT_TYPE, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"raw_contacts._id", "raw_contacts.contact_id", "raw_contacts.display_name", "raw_contacts.display_name_alt", "raw_contacts.display_name_source", "raw_contacts.account_name", "raw_contacts.account_type", "raw_contacts.times_contacted", "raw_contacts.last_time_contacted", "raw_contacts.starred", "raw_contacts.custom_ringtone"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.models.RawContact rawcontact = (net.frju.androidquery.models.RawContact)model;
            return rawcontact.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.models.RawContact rawcontact = (net.frju.androidquery.models.RawContact)model;
            rawcontact.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.models.RawContact rawcontact = (net.frju.androidquery.models.RawContact)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(DISPLAY_NAME_PRIMARY, rawcontact.displayNamePrimary);
            contentValues.put(DISPLAY_NAME_ALTERNATIVE, rawcontact.displayNameAlternative);
            contentValues.put(DISPLAY_NAME_SOURCE, rawcontact.displayNameSource);
            contentValues.put(ACCOUNT_NAME, rawcontact.accountName);
            contentValues.put(ACCOUNT_TYPE, rawcontact.accountType);
            contentValues.put(TIMES_CONTACTED, Integer.valueOf(rawcontact.timesContacted));
            contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(rawcontact.lastTimeContacted));
            contentValues.put(STARRED, Boolean.valueOf(rawcontact.starred));
            contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(rawcontact.customRingtone));
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class).getUri(net.frju.androidquery.models.RawContact.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.models.RawContact> count() {
            return Count.getBuilder(net.frju.androidquery.models.RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.models.RawContact> select() {
            return Select.getBuilder(net.frju.androidquery.models.RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.models.RawContact> delete() {
            return Delete.getBuilder(net.frju.androidquery.models.RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.models.RawContact> update() {
            return Update.getBuilder(net.frju.androidquery.models.RawContact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.RawContact> save(net.frju.androidquery.models.RawContact ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.models.RawContact> save(@NonNull List<net.frju.androidquery.models.RawContact> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.RawContact> insert(net.frju.androidquery.models.RawContact ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.models.RawContact> insert(@NonNull List<net.frju.androidquery.models.RawContact> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class), models);
        }

        @NonNull
        public static Raw.Builder raw(@NonNull String query) {
            return Raw.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(net.frju.androidquery.models.RawContact.class), (String)query);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.models.RawContact> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.models.RawContact.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class DefaultResolver
    implements Resolver {
        private static HashMap<Class<?>, DatabaseProvider> mProviders = new HashMap();

        public void init(@NonNull Context context) {
            BaseContentDatabaseProvider provider = new ContactContentDatabaseProvider(context.getApplicationContext());
            mProviders.put(net.frju.androidquery.models.RawContact.class, (DatabaseProvider)provider);
            mProviders.put(RawContact.class, (DatabaseProvider)provider);
            provider = new BlockedNumberContentDatabaseProvider(context.getApplicationContext());
            mProviders.put(net.frju.androidquery.models.BlockedNumber.class, (DatabaseProvider)provider);
            mProviders.put(BlockedNumber.class, (DatabaseProvider)provider);
            provider = new ContactContentDatabaseProvider(context.getApplicationContext());
            mProviders.put(net.frju.androidquery.models.Contact.class, (DatabaseProvider)provider);
            mProviders.put(Contact.class, (DatabaseProvider)provider);
        }

        @NonNull
        public Class<?> getModelClassFromName(@NonNull String modelDbName) {
            switch (modelDbName) {
                case "raw_contacts": {
                    return net.frju.androidquery.models.RawContact.class;
                }
                case "blocked": {
                    return net.frju.androidquery.models.BlockedNumber.class;
                }
                case "contacts": {
                    return net.frju.androidquery.models.Contact.class;
                }
            }
            throw new IllegalStateException("The modelDbName " + modelDbName + " is not a correct");
        }

        @NonNull
        public DbModelDescriptor getDbModelDescriptor(@NonNull Class<?> classDef) {
            if (classDef.isAssignableFrom(net.frju.androidquery.models.RawContact.class)) {
                return sRawContact;
            }
            if (classDef.isAssignableFrom(net.frju.androidquery.models.BlockedNumber.class)) {
                return sBlockedNumber;
            }
            if (classDef.isAssignableFrom(net.frju.androidquery.models.Contact.class)) {
                return sContact;
            }
            throw new IllegalStateException("Please ensure all SQL tables are annotated with @DbModel");
        }

        @NonNull
        public Class<?>[] getModelsForProvider(Class<? extends DatabaseProvider> providerClass) {
            ArrayList<Class<net.frju.androidquery.models.Contact>> result = new ArrayList<Class<net.frju.androidquery.models.Contact>>();
            if (ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.models.RawContact.class);
            }
            if (BlockedNumberContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.models.BlockedNumber.class);
            }
            if (ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.models.Contact.class);
            }
            if (result.size() == 0) {
                throw new IllegalStateException("This provider does not have any @DbModel models registered into that resolver");
            }
            return result.toArray(new Class[result.size()]);
        }

        public DatabaseProvider getDatabaseProviderForModel(Class<?> model) {
            return mProviders.get(model);
        }
    }
}

