/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.frju.androidquery.converter.UriConverter;
import net.frju.androidquery.database.BaseContentDatabaseProvider;
import net.frju.androidquery.database.BaseLocalDatabaseProvider;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.database.TableDescription;
import net.frju.androidquery.model.BlockedNumberContentDatabaseProvider;
import net.frju.androidquery.model.ContactContentDatabaseProvider;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class Q {
    private static DefaultResolver sResolver;
    private static RawContact sRawContact;
    private static BlockedNumber sBlockedNumber;
    private static Contact sContact;

    public static void init(Context context) {
        if (sResolver == null) {
            sResolver = new DefaultResolver();
            sResolver.init(context);
        }
    }

    public static DefaultResolver getResolver() {
        return sResolver;
    }

    static {
        sRawContact = new RawContact();
        sBlockedNumber = new BlockedNumber();
        sContact = new Contact();
    }

    public static class Contact
    implements TableDescription {
        public static final String ID = "_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PHOTO_URI = "photo_uri";
        public static final String PHOTO_THUMBNAIL_URI = "photo_thumb_uri";
        public static final String TIMES_CONTACTED = "times_contacted";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String LOOKUP_KEY = "lookup";
        public static final String IN_VISIBLE_GROUP = "in_visible_group";
        public static final String HAS_PHONE_NUMBER = "has_phone_number";

        @NonNull
        public String getTableRealName() {
            return "contacts";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE contacts (_id integer PRIMARY KEY AUTOINCREMENT,display_name text,photo_uri text,photo_thumb_uri text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text,lookup text,in_visible_group text,has_phone_number integer);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "display_name text", "photo_uri text", "photo_thumb_uri text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text", "lookup text", "in_visible_group text", "has_phone_number integer"};
        }

        public String getPrimaryKeyRealName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.model.Contact getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.Contact contact = new net.frju.androidquery.model.Contact();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        contact.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME)) {
                        contact.displayName = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(PHOTO_URI)) {
                        contact.photoUri = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(PHOTO_THUMBNAIL_URI)) {
                        contact.photoThumbnailUri = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                        contact.timesContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                        contact.lastTimeContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(STARRED)) {
                        contact.starred = cursor.getInt(x) == 1;
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) {
                        contact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LOOKUP_KEY)) {
                        contact.lookupKey = new UriConverter().convertFromDb(cursor.getString(x));
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(IN_VISIBLE_GROUP)) {
                        contact.inVisibleGroup = cursor.getString(x);
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(HAS_PHONE_NUMBER)) continue;
                    contact.hasPhoneNumber = cursor.getInt(x) == 1;
                }
                return contact;
            }
            return null;
        }

        public net.frju.androidquery.model.Contact[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.Contact[] result = new net.frju.androidquery.model.Contact[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, DISPLAY_NAME, PHOTO_URI, PHOTO_THUMBNAIL_URI, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE, LOOKUP_KEY, IN_VISIBLE_GROUP, HAS_PHONE_NUMBER};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"contacts._id", "contacts.display_name", "contacts.photo_uri", "contacts.photo_thumb_uri", "contacts.times_contacted", "contacts.last_time_contacted", "contacts.starred", "contacts.custom_ringtone", "contacts.lookup", "contacts.in_visible_group", "contacts.has_phone_number"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.model.Contact contact = (net.frju.androidquery.model.Contact)model;
            return contact.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.model.Contact contact = (net.frju.androidquery.model.Contact)model;
            contact.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.model.Contact contact = (net.frju.androidquery.model.Contact)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(DISPLAY_NAME, contact.displayName);
            contentValues.put(PHOTO_URI, new UriConverter().convertToDb(contact.photoUri));
            contentValues.put(PHOTO_THUMBNAIL_URI, new UriConverter().convertToDb(contact.photoThumbnailUri));
            contentValues.put(TIMES_CONTACTED, Integer.valueOf(contact.timesContacted));
            contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(contact.lastTimeContacted));
            contentValues.put(STARRED, Boolean.valueOf(contact.starred));
            contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(contact.customRingtone));
            contentValues.put(LOOKUP_KEY, new UriConverter().convertToDb(contact.lookupKey));
            contentValues.put(IN_VISIBLE_GROUP, contact.inVisibleGroup);
            contentValues.put(HAS_PHONE_NUMBER, Boolean.valueOf(contact.hasPhoneNumber));
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class).getUri(net.frju.androidquery.model.Contact.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.model.Contact> count() {
            return Count.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.model.Contact> selectViaContentProvider() {
            return Select.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.model.Contact> deleteViaContentProvider() {
            return Delete.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.model.Contact> updateViaContentProvider() {
            return Update.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.Contact> saveViaContentProvider(net.frju.androidquery.model.Contact ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.Contact> saveViaContentProvider(@NonNull List<net.frju.androidquery.model.Contact> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.Contact> insertViaContentProvider(net.frju.androidquery.model.Contact ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.Contact> insertViaContentProvider(@NonNull List<net.frju.androidquery.model.Contact> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), models);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.model.Contact> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.model.Contact.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class BlockedNumber
    implements TableDescription {
        public static final String ID = "_id";
        public static final String E164_NUMBER = "e164_number";
        public static final String ORIGINAL_NUMBER = "original_number";

        @NonNull
        public String getTableRealName() {
            return "blocked";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE blocked (_id integer PRIMARY KEY AUTOINCREMENT,e164_number text,original_number text);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "e164_number text", "original_number text"};
        }

        public String getPrimaryKeyRealName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.model.BlockedNumber getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.BlockedNumber blockednumber = new net.frju.androidquery.model.BlockedNumber();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        blockednumber.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(E164_NUMBER)) {
                        blockednumber.e164Number = cursor.getString(x);
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(ORIGINAL_NUMBER)) continue;
                    blockednumber.originalNumber = cursor.getString(x);
                }
                return blockednumber;
            }
            return null;
        }

        public net.frju.androidquery.model.BlockedNumber[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.BlockedNumber[] result = new net.frju.androidquery.model.BlockedNumber[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, E164_NUMBER, ORIGINAL_NUMBER};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"blocked._id", "blocked.e164_number", "blocked.original_number"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.model.BlockedNumber blockednumber = (net.frju.androidquery.model.BlockedNumber)model;
            return blockednumber.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.model.BlockedNumber blockednumber = (net.frju.androidquery.model.BlockedNumber)model;
            blockednumber.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.model.BlockedNumber blockednumber = (net.frju.androidquery.model.BlockedNumber)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(E164_NUMBER, blockednumber.e164Number);
            contentValues.put(ORIGINAL_NUMBER, blockednumber.originalNumber);
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class).getUri(net.frju.androidquery.model.BlockedNumber.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.model.BlockedNumber> count() {
            return Count.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.model.BlockedNumber> selectViaContentProvider() {
            return Select.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.model.BlockedNumber> deleteViaContentProvider() {
            return Delete.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.model.BlockedNumber> updateViaContentProvider() {
            return Update.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.BlockedNumber> saveViaContentProvider(net.frju.androidquery.model.BlockedNumber ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.BlockedNumber> saveViaContentProvider(@NonNull List<net.frju.androidquery.model.BlockedNumber> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.BlockedNumber> insertViaContentProvider(net.frju.androidquery.model.BlockedNumber ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.BlockedNumber> insertViaContentProvider(@NonNull List<net.frju.androidquery.model.BlockedNumber> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), models);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.model.BlockedNumber> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.model.BlockedNumber.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class RawContact
    implements TableDescription {
        public static final String ID = "_id";
        public static final String CONTACT_ID = "contact_id";
        public static final String DISPLAY_NAME_PRIMARY = "display_name";
        public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String TIMES_CONTACTED = "times_contacted";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";

        @NonNull
        public String getTableRealName() {
            return "raw_contacts";
        }

        @NonNull
        public String getTableCreateQuery() {
            return "CREATE TABLE raw_contacts (_id integer PRIMARY KEY AUTOINCREMENT,contact_id integer,display_name text,display_name_alt text,display_name_source text,account_name text,account_type text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text);";
        }

        @NonNull
        public String[] getColumnsSqlArray() {
            return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "contact_id integer", "display_name text", "display_name_alt text", "display_name_source text", "account_name text", "account_type text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text"};
        }

        public String getPrimaryKeyRealName() {
            return ID;
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.model.RawContact getSingleResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.RawContact rawcontact = new net.frju.androidquery.model.RawContact();
                for (int x = 0; x < cursor.getColumnCount(); ++x) {
                    if (cursor.getColumnName(x).equals(ID)) {
                        rawcontact.id = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(CONTACT_ID)) {
                        rawcontact.contactId = cursor.getLong(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_PRIMARY)) {
                        rawcontact.displayNamePrimary = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_ALTERNATIVE)) {
                        rawcontact.displayNameAlternative = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(DISPLAY_NAME_SOURCE)) {
                        rawcontact.displayNameSource = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(ACCOUNT_NAME)) {
                        rawcontact.accountName = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(ACCOUNT_TYPE)) {
                        rawcontact.accountType = cursor.getString(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                        rawcontact.timesContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                        rawcontact.lastTimeContacted = cursor.getInt(x);
                        continue;
                    }
                    if (cursor.getColumnName(x).equals(STARRED)) {
                        rawcontact.starred = cursor.getInt(x) == 1;
                        continue;
                    }
                    if (!cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) continue;
                    rawcontact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                }
                return rawcontact;
            }
            return null;
        }

        public net.frju.androidquery.model.RawContact[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.RawContact[] result = new net.frju.androidquery.model.RawContact[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, CONTACT_ID, DISPLAY_NAME_PRIMARY, DISPLAY_NAME_ALTERNATIVE, DISPLAY_NAME_SOURCE, ACCOUNT_NAME, ACCOUNT_TYPE, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"raw_contacts._id", "raw_contacts.contact_id", "raw_contacts.display_name", "raw_contacts.display_name_alt", "raw_contacts.display_name_source", "raw_contacts.account_name", "raw_contacts.account_type", "raw_contacts.times_contacted", "raw_contacts.last_time_contacted", "raw_contacts.starred", "raw_contacts.custom_ringtone"};
        }

        public Object getPrimaryKeyValue(@NonNull Object model) {
            net.frju.androidquery.model.RawContact rawcontact = (net.frju.androidquery.model.RawContact)model;
            return rawcontact.id;
        }

        public void setIdToModel(@NonNull Object model, long id) {
            net.frju.androidquery.model.RawContact rawcontact = (net.frju.androidquery.model.RawContact)model;
            rawcontact.id = id;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return true;
        }

        @NonNull
        public ContentValues getContentValues(@NonNull Object model) {
            net.frju.androidquery.model.RawContact rawcontact = (net.frju.androidquery.model.RawContact)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(DISPLAY_NAME_PRIMARY, rawcontact.displayNamePrimary);
            contentValues.put(DISPLAY_NAME_ALTERNATIVE, rawcontact.displayNameAlternative);
            contentValues.put(DISPLAY_NAME_SOURCE, rawcontact.displayNameSource);
            contentValues.put(ACCOUNT_NAME, rawcontact.accountName);
            contentValues.put(ACCOUNT_TYPE, rawcontact.accountType);
            contentValues.put(TIMES_CONTACTED, Integer.valueOf(rawcontact.timesContacted));
            contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(rawcontact.lastTimeContacted));
            contentValues.put(STARRED, Boolean.valueOf(rawcontact.starred));
            contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(rawcontact.customRingtone));
            return contentValues;
        }

        @NonNull
        public static Uri getContentUri() {
            return Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class).getUri(net.frju.androidquery.model.RawContact.class);
        }

        @NonNull
        public static Count.Builder<net.frju.androidquery.model.RawContact> count() {
            return Count.getBuilder(net.frju.androidquery.model.RawContact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class));
        }

        @NonNull
        public static Select.Builder<net.frju.androidquery.model.RawContact> selectViaContentProvider() {
            return Select.getBuilder(net.frju.androidquery.model.RawContact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class));
        }

        @NonNull
        public static Delete.Builder<net.frju.androidquery.model.RawContact> deleteViaContentProvider() {
            return Delete.getBuilder(net.frju.androidquery.model.RawContact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class));
        }

        @NonNull
        public static Update.Builder<net.frju.androidquery.model.RawContact> updateViaContentProvider() {
            return Update.getBuilder(net.frju.androidquery.model.RawContact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class));
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.RawContact> saveViaContentProvider(net.frju.androidquery.model.RawContact ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class), (Object[])models);
        }

        @NonNull
        public static Save.Builder<net.frju.androidquery.model.RawContact> saveViaContentProvider(@NonNull List<net.frju.androidquery.model.RawContact> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class), models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.RawContact> insertViaContentProvider(net.frju.androidquery.model.RawContact ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class), (Object[])models);
        }

        @NonNull
        public static Insert.Builder<net.frju.androidquery.model.RawContact> insertViaContentProvider(@NonNull List<net.frju.androidquery.model.RawContact> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.RawContact.class), models);
        }

        @NonNull
        public static CursorResult<net.frju.androidquery.model.RawContact> fromCursor(Cursor cursor) {
            return new CursorResult(net.frju.androidquery.model.RawContact.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class DefaultResolver
    implements Resolver {
        private static HashMap<Class<?>, BaseLocalDatabaseProvider> mLocalProviders = new HashMap();
        private static HashMap<Class<?>, BaseContentDatabaseProvider> mContentProviders = new HashMap();

        public void init(@NonNull Context context) {
            BaseContentDatabaseProvider contentProvider = new ContactContentDatabaseProvider(context.getContentResolver());
            mContentProviders.put(net.frju.androidquery.model.RawContact.class, contentProvider);
            mContentProviders.put(RawContact.class, contentProvider);
            contentProvider = new BlockedNumberContentDatabaseProvider(context.getContentResolver());
            mContentProviders.put(net.frju.androidquery.model.BlockedNumber.class, contentProvider);
            mContentProviders.put(BlockedNumber.class, contentProvider);
            contentProvider = new ContactContentDatabaseProvider(context.getContentResolver());
            mContentProviders.put(net.frju.androidquery.model.Contact.class, contentProvider);
            mContentProviders.put(Contact.class, contentProvider);
        }

        @NonNull
        public TableDescription getTableDescription(@NonNull Class<?> classDef) {
            if (classDef.isAssignableFrom(net.frju.androidquery.model.RawContact.class)) {
                return sRawContact;
            }
            if (classDef.isAssignableFrom(net.frju.androidquery.model.BlockedNumber.class)) {
                return sBlockedNumber;
            }
            if (classDef.isAssignableFrom(net.frju.androidquery.model.Contact.class)) {
                return sContact;
            }
            throw new IllegalStateException("Please ensure all SQL tables are annotated with @Table");
        }

        @NonNull
        public Class<?>[] getModelsForProvider(Class<? extends DatabaseProvider> providerClass) {
            ArrayList<Class<net.frju.androidquery.model.Contact>> result = new ArrayList<Class<net.frju.androidquery.model.Contact>>();
            if (Void.class.equals(providerClass) || ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.model.RawContact.class);
            }
            if (Void.class.equals(providerClass) || BlockedNumberContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.model.BlockedNumber.class);
            }
            if (Void.class.equals(providerClass) || ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.model.Contact.class);
            }
            if (result.size() == 0) {
                throw new IllegalStateException("This provider does not have any @Table models registered into that resolver");
            }
            return result.toArray(new Class[result.size()]);
        }

        public BaseLocalDatabaseProvider getLocalDatabaseProviderForModel(Class<?> model) {
            return mLocalProviders.get(model);
        }

        public BaseContentDatabaseProvider getContentDatabaseProviderForModel(Class<?> model) {
            return mContentProviders.get(model);
        }
    }
}

