/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.frju.androidquery.converter.UriConverter;
import net.frju.androidquery.database.BaseContentDatabaseProvider;
import net.frju.androidquery.database.BaseLocalDatabaseProvider;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.database.TableDescription;
import net.frju.androidquery.model.BlockedNumberContentDatabaseProvider;
import net.frju.androidquery.model.ContactContentDatabaseProvider;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Result;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class Q {
    private static DefaultResolver sResolver;
    private static BlockedNumber sBlockedNumber;
    private static Contact sContact;

    public static void init(Context context) {
        if (sResolver == null) {
            sResolver = new DefaultResolver();
            sResolver.init(context);
        }
    }

    public static DefaultResolver getResolver() {
        return sResolver;
    }

    static {
        sBlockedNumber = new BlockedNumber();
        sContact = new Contact();
    }

    public static class Contact
    implements TableDescription {
        public static final String ID = "_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PHOTO_URI = "photo_uri";
        public static final String PHOTO_THUMBNAIL_URI = "photo_thumb_uri";
        public static final String STARRED = "starred";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String LOOKUP_KEY = "lookup";

        public String getTableRealName() {
            return "contacts";
        }

        public String getTableInsertQuery() {
            return "CREATE TABLE contacts (_id integer,display_name text,photo_uri text,photo_thumb_uri text,starred integer,custom_ringtone text,lookup text);";
        }

        public String getPrimaryKeyRealName() {
            return "";
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.model.Contact getSingleResult(Cursor cursor) {
            net.frju.androidquery.model.Contact contact = new net.frju.androidquery.model.Contact();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    contact.id = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME)) {
                    contact.displayName = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(PHOTO_URI)) {
                    contact.photoUri = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(PHOTO_THUMBNAIL_URI)) {
                    contact.photoThumbnailUri = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(STARRED)) {
                    contact.starred = cursor.getInt(x) == 1;
                    continue;
                }
                if (cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) {
                    contact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (!cursor.getColumnName(x).equals(LOOKUP_KEY)) continue;
                contact.lookupKey = new UriConverter().convertFromDb(cursor.getString(x));
            }
            return contact;
        }

        public net.frju.androidquery.model.Contact[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.Contact[] result = new net.frju.androidquery.model.Contact[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, DISPLAY_NAME, PHOTO_URI, PHOTO_THUMBNAIL_URI, STARRED, CUSTOM_RINGTONE, LOOKUP_KEY};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"contacts._id", "contacts.display_name", "contacts.photo_uri", "contacts.photo_thumb_uri", "contacts.starred", "contacts.custom_ringtone", "contacts.lookup"};
        }

        public Object getPrimaryKeyValue(Object model) {
            net.frju.androidquery.model.Contact contact = (net.frju.androidquery.model.Contact)model;
            return null;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return false;
        }

        public ContentValues getContentValues(Object model) {
            net.frju.androidquery.model.Contact contact = (net.frju.androidquery.model.Contact)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(ID, Integer.valueOf(contact.id));
            contentValues.put(DISPLAY_NAME, contact.displayName);
            contentValues.put(PHOTO_URI, new UriConverter().convertToDb(contact.photoUri));
            contentValues.put(PHOTO_THUMBNAIL_URI, new UriConverter().convertToDb(contact.photoThumbnailUri));
            contentValues.put(STARRED, Boolean.valueOf(contact.starred));
            contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(contact.customRingtone));
            contentValues.put(LOOKUP_KEY, new UriConverter().convertToDb(contact.lookupKey));
            return contentValues;
        }

        public static Uri getContentUri() {
            return Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class).getUri(net.frju.androidquery.model.Contact.class);
        }

        public static Count.Builder<net.frju.androidquery.model.Contact> count() {
            return Count.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        public static Select.Builder<net.frju.androidquery.model.Contact> select() {
            return Select.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        public static Delete.Builder<net.frju.androidquery.model.Contact> deleteViaContentProvider() {
            return Delete.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        public static Update.Builder<net.frju.androidquery.model.Contact> updateViaContentProvider() {
            return Update.getBuilder(net.frju.androidquery.model.Contact.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class));
        }

        public static Save.Builder<net.frju.androidquery.model.Contact> saveViaContentProvider(net.frju.androidquery.model.Contact ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), (Object[])models);
        }

        public static Save.Builder<net.frju.androidquery.model.Contact> saveViaContentProvider(List<net.frju.androidquery.model.Contact> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), models);
        }

        public static Insert.Builder<net.frju.androidquery.model.Contact> insertViaContentProvider(net.frju.androidquery.model.Contact ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), (Object[])models);
        }

        public static Insert.Builder<net.frju.androidquery.model.Contact> insertViaContentProvider(List<net.frju.androidquery.model.Contact> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.Contact.class), models);
        }

        public static Result<net.frju.androidquery.model.Contact> fromCursor(Cursor cursor) {
            return new Result(net.frju.androidquery.model.Contact.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class BlockedNumber
    implements TableDescription {
        public static final String ID = "_id";
        public static final String E164_NUMBER = "e164_number";
        public static final String ORIGINAL_NUMBER = "original_number";

        public String getTableRealName() {
            return "blocked";
        }

        public String getTableInsertQuery() {
            return "CREATE TABLE blocked (_id integer,e164_number text,original_number text);";
        }

        public String getPrimaryKeyRealName() {
            return "";
        }

        public String[] getIndexNames() {
            return new String[0];
        }

        public String getCreateIndexQuery() {
            StringBuilder sb = new StringBuilder();
            return sb.length() > 0 ? sb.toString() : null;
        }

        public net.frju.androidquery.model.BlockedNumber getSingleResult(Cursor cursor) {
            net.frju.androidquery.model.BlockedNumber blockednumber = new net.frju.androidquery.model.BlockedNumber();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    blockednumber.id = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(E164_NUMBER)) {
                    blockednumber.e164Number = cursor.getString(x);
                    continue;
                }
                if (!cursor.getColumnName(x).equals(ORIGINAL_NUMBER)) continue;
                blockednumber.originalNumber = cursor.getString(x);
            }
            return blockednumber;
        }

        public net.frju.androidquery.model.BlockedNumber[] getArrayResult(Cursor cursor) {
            if (cursor != null) {
                net.frju.androidquery.model.BlockedNumber[] result = new net.frju.androidquery.model.BlockedNumber[cursor.getCount()];
                cursor.moveToFirst();
                int i = 0;
                while (!cursor.isAfterLast()) {
                    result[i] = this.getSingleResult(cursor);
                    cursor.moveToNext();
                    ++i;
                }
                cursor.close();
                return result;
            }
            return null;
        }

        public String[] getColumnNames() {
            return new String[]{ID, E164_NUMBER, ORIGINAL_NUMBER};
        }

        public String[] getColumnNamesWithTablePrefix() {
            return new String[]{"blocked._id", "blocked.e164_number", "blocked.original_number"};
        }

        public Object getPrimaryKeyValue(Object model) {
            net.frju.androidquery.model.BlockedNumber blockednumber = (net.frju.androidquery.model.BlockedNumber)model;
            return null;
        }

        public boolean isPrimaryKeyAutoIncrement() {
            return false;
        }

        public ContentValues getContentValues(Object model) {
            net.frju.androidquery.model.BlockedNumber blockednumber = (net.frju.androidquery.model.BlockedNumber)model;
            ContentValues contentValues = new ContentValues();
            contentValues.put(ID, Integer.valueOf(blockednumber.id));
            contentValues.put(E164_NUMBER, blockednumber.e164Number);
            contentValues.put(ORIGINAL_NUMBER, blockednumber.originalNumber);
            return contentValues;
        }

        public static Uri getContentUri() {
            return Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class).getUri(net.frju.androidquery.model.BlockedNumber.class);
        }

        public static Count.Builder<net.frju.androidquery.model.BlockedNumber> count() {
            return Count.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        public static Select.Builder<net.frju.androidquery.model.BlockedNumber> select() {
            return Select.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        public static Delete.Builder<net.frju.androidquery.model.BlockedNumber> deleteViaContentProvider() {
            return Delete.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        public static Update.Builder<net.frju.androidquery.model.BlockedNumber> updateViaContentProvider() {
            return Update.getBuilder(net.frju.androidquery.model.BlockedNumber.class, (DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class));
        }

        public static Save.Builder<net.frju.androidquery.model.BlockedNumber> saveViaContentProvider(net.frju.androidquery.model.BlockedNumber ... models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), (Object[])models);
        }

        public static Save.Builder<net.frju.androidquery.model.BlockedNumber> saveViaContentProvider(List<net.frju.androidquery.model.BlockedNumber> models) {
            return Save.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), models);
        }

        public static Insert.Builder<net.frju.androidquery.model.BlockedNumber> insertViaContentProvider(net.frju.androidquery.model.BlockedNumber ... models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), (Object[])models);
        }

        public static Insert.Builder<net.frju.androidquery.model.BlockedNumber> insertViaContentProvider(List<net.frju.androidquery.model.BlockedNumber> models) {
            return Insert.getBuilder((DatabaseProvider)Q.getResolver().getContentDatabaseProviderForModel(net.frju.androidquery.model.BlockedNumber.class), models);
        }

        public static Result<net.frju.androidquery.model.BlockedNumber> fromCursor(Cursor cursor) {
            return new Result(net.frju.androidquery.model.BlockedNumber.class, (Resolver)Q.getResolver(), cursor);
        }
    }

    public static class DefaultResolver
    implements Resolver {
        private static HashMap<Class<?>, BaseLocalDatabaseProvider> mLocalProviders = new HashMap();
        private static HashMap<Class<?>, BaseContentDatabaseProvider> mContentProviders = new HashMap();

        public void init(Context context) {
            mContentProviders.put(net.frju.androidquery.model.BlockedNumber.class, new BlockedNumberContentDatabaseProvider(context.getContentResolver()));
            mContentProviders.put(net.frju.androidquery.model.Contact.class, new ContactContentDatabaseProvider(context.getContentResolver()));
        }

        public TableDescription getTableDescription(Class<?> classDef) {
            if (classDef.isAssignableFrom(net.frju.androidquery.model.BlockedNumber.class)) {
                return sBlockedNumber;
            }
            if (classDef.isAssignableFrom(net.frju.androidquery.model.Contact.class)) {
                return sContact;
            }
            throw new IllegalStateException("Please ensure all SQL tables are annotated with @Table");
        }

        public Class<?>[] getModelsForProvider(Class<? extends DatabaseProvider> providerClass) {
            ArrayList<Class> result = new ArrayList<Class>();
            if (Void.class.equals(providerClass) || BlockedNumberContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.model.BlockedNumber.class);
            }
            if (Void.class.equals(providerClass) || ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(net.frju.androidquery.model.Contact.class);
            }
            if (result.size() == 0) {
                throw new IllegalStateException("This provider does not have any @Table models registered into that resolver");
            }
            return result.toArray(new Class[result.size()]);
        }

        public BaseLocalDatabaseProvider getLocalDatabaseProviderForModel(Class<?> model) {
            return mLocalProviders.get(model);
        }

        public BaseContentDatabaseProvider getContentDatabaseProviderForModel(Class<?> model) {
            return mContentProviders.get(model);
        }
    }
}

