/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.sesametools.ldserver.RDFMediaTypes;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.restlet.representation.OutputRepresentation;

public class RDFRepresentation
extends OutputRepresentation {
    private static final Logger LOGGER = Logger.getLogger(RDFRepresentation.class.getName());
    private final Collection<Statement> statements;
    private final Collection<Namespace> namespaces;
    private final RDFFormat format;

    public RDFRepresentation(Collection<Statement> statements, Collection<Namespace> namespaces, RDFFormat format) {
        super(RDFMediaTypes.findMediaType(format));
        this.statements = statements;
        this.namespaces = namespaces;
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os) throws IOException {
        try {
            RDFWriter writer = Rio.createWriter((RDFFormat)this.format, (OutputStream)os);
            writer.startRDF();
            try {
                for (Namespace ns : this.namespaces) {
                    writer.handleNamespace(ns.getPrefix(), ns.getName());
                }
                for (Statement st : this.statements) {
                    writer.handleStatement(st);
                }
                writer.handleComment("created by TwitLogic using the Sesame 2 RDF framework");
            }
            finally {
                writer.endRDF();
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            LOGGER.log(Level.WARNING, "failed to write RDF representation", t);
            throw new IOException(t.getMessage());
        }
    }
}

