/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrdf.rio.RDFFormat;
import org.restlet.data.MediaType;
import org.restlet.representation.Variant;

public class RDFMediaTypes {
    private static final Map<RDFFormat, MediaType> rdfFormatToMediaTypeMap = new HashMap<RDFFormat, MediaType>();
    private static final Map<MediaType, RDFFormat> mediaTypeToRdfFormatMap = new LinkedHashMap<MediaType, RDFFormat>();
    private static final List<Variant> rdfVariants;
    private static final Map<String, RDFFormat> SUFFIX_TO_FORMAT;
    private static final Map<RDFFormat, String> FORMAT_TO_SUFFIX;

    public static List<Variant> getRDFVariants() {
        return rdfVariants;
    }

    public static RDFFormat findRdfFormat(MediaType mediaType) {
        return mediaTypeToRdfFormatMap.get(mediaType);
    }

    public static MediaType findMediaType(RDFFormat format) {
        return rdfFormatToMediaTypeMap.get(format);
    }

    public static Variant findVariant(RDFFormat format) {
        return new Variant(RDFMediaTypes.findMediaType(format));
    }

    public static RDFFormat findFormat(String suffix) {
        return SUFFIX_TO_FORMAT.get(suffix);
    }

    public static String findSuffix(RDFFormat format) {
        return FORMAT_TO_SUFFIX.get(format);
    }

    private static void registerRdfFormat(RDFFormat format) {
        MediaType t = RDFFormat.RDFXML == format ? MediaType.APPLICATION_RDF_XML : new MediaType(format.getDefaultMIMEType());
        rdfFormatToMediaTypeMap.put(format, t);
        mediaTypeToRdfFormatMap.put(t, format);
    }

    static {
        RDFMediaTypes.registerRdfFormat(RDFFormat.RDFXML);
        RDFMediaTypes.registerRdfFormat(RDFFormat.TURTLE);
        RDFMediaTypes.registerRdfFormat(RDFFormat.N3);
        RDFMediaTypes.registerRdfFormat(RDFFormat.NTRIPLES);
        RDFMediaTypes.registerRdfFormat(RDFFormat.TRIG);
        RDFMediaTypes.registerRdfFormat(RDFFormat.TRIX);
        rdfVariants = new LinkedList<Variant>();
        for (MediaType mediaType : mediaTypeToRdfFormatMap.keySet()) {
            rdfVariants.add(new Variant(mediaType));
        }
        FORMAT_TO_SUFFIX = new HashMap<RDFFormat, String>();
        FORMAT_TO_SUFFIX.put(RDFFormat.RDFXML, "rdf");
        FORMAT_TO_SUFFIX.put(RDFFormat.TURTLE, "ttl");
        FORMAT_TO_SUFFIX.put(RDFFormat.N3, "n3");
        FORMAT_TO_SUFFIX.put(RDFFormat.NTRIPLES, "nt");
        FORMAT_TO_SUFFIX.put(RDFFormat.TRIG, "trig");
        FORMAT_TO_SUFFIX.put(RDFFormat.TRIX, "trix");
        SUFFIX_TO_FORMAT = new HashMap<String, RDFFormat>();
        for (RDFFormat format : FORMAT_TO_SUFFIX.keySet()) {
            SUFFIX_TO_FORMAT.put(FORMAT_TO_SUFFIX.get(format), format);
        }
    }
}

