/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import java.time.Month;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_ACT_YEARFRAC
extends DayCountConvention_ACT {
    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        double denominator;
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        LocalDate startDatePlusOneYear = startDate.plusYears(1L);
        if (endDate.isAfter(startDatePlusOneYear)) {
            LocalDate startDateYearStart = startDate.withDayOfYear(1);
            LocalDate endDateYearEnd = endDate.withDayOfYear(endDate.lengthOfYear()).plusDays(1L);
            double spannedYears = endDate.getYear() - startDate.getYear() + 1;
            denominator = this.getDaycount(startDateYearStart, endDateYearEnd) / spannedYears;
        } else {
            boolean isStartLeapYear = startDate.isLeapYear();
            boolean isEndLeapYear = endDate.isLeapYear();
            if (isStartLeapYear && isEndLeapYear) {
                denominator = 366.0;
            } else if (isStartLeapYear || isEndLeapYear) {
                LocalDate leapYearsFeb29th;
                LocalDate localDate = leapYearsFeb29th = isStartLeapYear ? LocalDate.of(startDate.getYear(), Month.FEBRUARY, 29) : LocalDate.of(endDate.getYear(), Month.FEBRUARY, 29);
                denominator = startDate.compareTo(leapYearsFeb29th) <= 0 && endDate.compareTo(leapYearsFeb29th) >= 0 ? 366.0 : 365.0;
            } else {
                denominator = 365.0;
            }
        }
        double daycountFraction = this.getDaycount(startDate, endDate) / denominator;
        return daycountFraction;
    }

    public String toString() {
        return "DayCountConvention_ACT_ACT_YEARFRAC";
    }
}

