/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import net.finmath.time.daycount.DayCountConventionInterface;

public class DayCountConvention_30E_360
implements DayCountConventionInterface {
    private final boolean is30Eplus360;

    public DayCountConvention_30E_360(boolean is30Eplus360) {
        this.is30Eplus360 = is30Eplus360;
    }

    public DayCountConvention_30E_360() {
        this(false);
    }

    @Override
    public double getDaycount(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycount(endDate, startDate);
        }
        int startDateDay = startDate.getDayOfMonth();
        int startDateMonth = startDate.getMonthValue();
        int startDateYear = startDate.getYear();
        int endDateDay = endDate.getDayOfMonth();
        int endDateMonth = endDate.getMonthValue();
        int endDateYear = endDate.getYear();
        double daycount = (double)(endDateYear - startDateYear) * 360.0 + (double)(endDateMonth - startDateMonth) * 30.0 + (Math.min((double)endDateDay, 30.0) - Math.min((double)startDateDay, 30.0));
        if (this.is30Eplus360 && endDateDay == 31) {
            daycount += 1.0;
        }
        return daycount;
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        return this.getDaycount(startDate, endDate) / 360.0;
    }
}

