/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import net.finmath.time.TimeDiscretizationInterface;

public class TimeDiscretization
implements Serializable,
TimeDiscretizationInterface {
    private static final long serialVersionUID = 6880668325019167781L;
    private static final double timeTickSizeDefault = Double.parseDouble(System.getProperty("net.finmath.functions.TimeDiscretization.timeTickSize", new Double(1.1415525114155251E-4).toString()));
    private final double[] timeDiscretization;
    private final double timeTickSize = timeTickSizeDefault;

    public TimeDiscretization(double ... times) {
        this.timeDiscretization = (double[])times.clone();
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(Double[] times) {
        this.timeDiscretization = new double[times.length];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
            this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(times[timeIndex]);
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(ArrayList<Double> timeDiscretization) {
        this.timeDiscretization = new double[timeDiscretization.size()];
        for (int timeIndex = 0; timeIndex < timeDiscretization.size(); ++timeIndex) {
            this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(timeDiscretization.get(timeIndex));
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(Set<Double> times) {
        this.timeDiscretization = new double[times.size()];
        Iterator<Double> time = times.iterator();
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
            this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(time.next());
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(double initial, int numberOfTimeSteps, double deltaT) {
        this.timeDiscretization = new double[numberOfTimeSteps + 1];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
            this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(initial + (double)timeIndex * deltaT);
        }
    }

    public TimeDiscretization(double initial, double last, double deltaT, ShortPeriodLocation shortPeriodLocation) {
        int numberOfTimeSteps = (int)((last - initial) / deltaT + 0.5);
        if (this.roundToTimeTickSize(initial + (double)numberOfTimeSteps * deltaT) < this.roundToTimeTickSize(last)) {
            ++numberOfTimeSteps;
        }
        this.timeDiscretization = new double[numberOfTimeSteps + 1];
        if (shortPeriodLocation == ShortPeriodLocation.SHORT_PERIOD_AT_END) {
            for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
                this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(initial + (double)timeIndex * deltaT);
            }
            this.timeDiscretization[this.timeDiscretization.length - 1] = last;
        } else {
            for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
                this.timeDiscretization[timeIndex] = this.roundToTimeTickSize(last - (double)(numberOfTimeSteps - timeIndex) * deltaT);
            }
            this.timeDiscretization[0] = initial;
        }
    }

    @Override
    public int getNumberOfTimes() {
        return this.timeDiscretization.length;
    }

    @Override
    public int getNumberOfTimeSteps() {
        return this.timeDiscretization.length - 1;
    }

    @Override
    public double getTime(int timeIndex) {
        return this.timeDiscretization[timeIndex];
    }

    @Override
    public double getTimeStep(int timeIndex) {
        return this.timeDiscretization[timeIndex + 1] - this.timeDiscretization[timeIndex];
    }

    @Override
    public int getTimeIndex(double time) {
        int index = Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(time));
        return index;
    }

    @Override
    public int getTimeIndexNearestLessOrEqual(double time) {
        int index = Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(time));
        if (index < 0) {
            index = -index - 2;
        }
        return index;
    }

    @Override
    public int getTimeIndexNearestGreaterOrEqual(double time) {
        int index = Arrays.binarySearch(this.timeDiscretization, time);
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    @Override
    public double[] getAsDoubleArray() {
        return (double[])this.timeDiscretization.clone();
    }

    @Override
    public ArrayList<Double> getAsArrayList() {
        ArrayList<Double> times = new ArrayList<Double>(this.timeDiscretization.length);
        for (double aTimeDiscretization : this.timeDiscretization) {
            times.add(aTimeDiscretization);
        }
        return times;
    }

    @Override
    public TimeDiscretizationInterface getTimeShiftedTimeDiscretization(double timeShift) {
        double[] newTimeDiscretization = new double[this.timeDiscretization.length];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
            newTimeDiscretization[timeIndex] = this.roundToTimeTickSize(this.timeDiscretization[timeIndex] + timeShift);
        }
        return new TimeDiscretization(newTimeDiscretization);
    }

    @Override
    public Iterator<Double> iterator() {
        return this.getAsArrayList().iterator();
    }

    public String toString() {
        return "TimeDiscretization [timeDiscretization=" + Arrays.toString(this.timeDiscretization) + ", timeTickSize=" + this.timeTickSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.timeDiscretization);
        long temp = Double.doubleToLongBits(this.timeTickSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDiscretization other = (TimeDiscretization)obj;
        if (!Arrays.equals(this.timeDiscretization, other.timeDiscretization)) {
            return false;
        }
        return Double.doubleToLongBits(this.timeTickSize) == Double.doubleToLongBits(other.timeTickSize);
    }

    private double roundToTimeTickSize(double time) {
        return Math.rint(time / this.timeTickSize) * this.timeTickSize;
    }

    public static enum ShortPeriodLocation {
        SHORT_PERIOD_AT_START,
        SHORT_PERIOD_AT_END;

    }
}

