/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.time.LocalDate;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.TenorInterface;
import net.finmath.time.TimeDiscretization;

public class Tenor
extends TimeDiscretization
implements TenorInterface {
    private static final long serialVersionUID = 4027884423439197483L;
    private LocalDate referenceDate;
    private LocalDate[] dates;

    public Tenor(LocalDate[] dates, LocalDate referenceDate) {
        super(Tenor.createTimeDiscretizationFromDates(dates, referenceDate));
        this.dates = dates;
        this.referenceDate = referenceDate;
    }

    private static double[] createTimeDiscretizationFromDates(LocalDate[] dates, LocalDate referenceDate) {
        double[] timeDiscretization = new double[dates.length];
        for (int timeIndex = 0; timeIndex < timeDiscretization.length; ++timeIndex) {
            timeDiscretization[timeIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, dates[timeIndex]);
        }
        return timeDiscretization;
    }

    public Tenor(double[] timeDiscretization) {
        super(timeDiscretization);
    }

    public Tenor(Double[] timeDiscretization) {
        super(timeDiscretization);
    }

    public Tenor(double initial, int numberOfTimeSteps, double deltaT) {
        super(initial, numberOfTimeSteps, deltaT);
    }

    public Tenor(double initial, double last, double deltaT, TimeDiscretization.ShortPeriodLocation shortPeriodLocation) {
        super(initial, last, deltaT, shortPeriodLocation);
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public LocalDate getDate(int timeIndex) {
        return this.dates[timeIndex];
    }

    @Override
    public double getDaycountFraction(int timeIndex) {
        return this.getTimeStep(timeIndex);
    }

    @Override
    public String toString() {
        String datesOutputString = "[";
        for (int iDate = 0; iDate < this.dates.length; ++iDate) {
            datesOutputString = datesOutputString + this.dates[iDate].toString() + (iDate == this.dates.length - 1 ? "" : ", ");
        }
        datesOutputString = datesOutputString + "]";
        return "Tenor [referenceDate=" + this.referenceDate + ", dates=" + datesOutputString + "]";
    }
}

