/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import java.text.DecimalFormat;
import net.finmath.rootfinder.BisectionSearch;
import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.rootfinder.RiddersMethod;
import net.finmath.rootfinder.RootFinder;
import net.finmath.rootfinder.RootFinderWithDerivative;
import net.finmath.rootfinder.SecantMethod;

public class TestRootFinders {
    public static void main(String[] args) {
        System.out.println("Applying root finders to x^3 + 2*y^2 + x + 1 = 0\n");
        System.out.println("Root finders without derivative:");
        System.out.println("--------------------------------");
        RootFinder rootFinder = new BisectionSearch(-10.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        rootFinder = new RiddersMethod(-10.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        rootFinder = new SecantMethod(2.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        System.out.println("");
        System.out.println("Root finders with    derivative:");
        System.out.println("--------------------------------");
        NewtonsMethod rootFinderWithDerivative = new NewtonsMethod(2.0);
        TestRootFinders.testRootFinderWithDerivative(rootFinderWithDerivative);
        rootFinderWithDerivative = new SecantMethod(2.0, 10.0);
        TestRootFinders.testRootFinderWithDerivative(rootFinderWithDerivative);
    }

    public static void testRootFinder(RootFinder rootFinder) {
        System.out.println("Testing " + rootFinder.getClass().getName() + ":");
        while (rootFinder.getAccuracy() > 1.0E-11 && !rootFinder.isDone()) {
            double x = rootFinder.getNextPoint();
            double y = x * x * x + x * x + x + 1.0;
            rootFinder.setValue(y);
        }
        DecimalFormat formatter = new DecimalFormat("0.00E00");
        System.out.print("Root......: " + formatter.format(rootFinder.getBestPoint()) + "\t");
        System.out.print("Accuracy..: " + formatter.format(rootFinder.getAccuracy()) + "\t");
        System.out.print("Iterations: " + rootFinder.getNumberOfIterations() + "\n");
    }

    public static void testRootFinderWithDerivative(RootFinderWithDerivative rootFinder) {
        System.out.println("Testing " + rootFinder.getClass().getName() + ":");
        while (rootFinder.getAccuracy() > 1.0E-11 && !rootFinder.isDone()) {
            double x = rootFinder.getNextPoint();
            double y = x * x * x + x * x + x + 1.0;
            double p = 3.0 * x * x + 2.0 * x + 1.0;
            rootFinder.setValueAndDerivative(y, p);
        }
        DecimalFormat formatter = new DecimalFormat("0.00E00");
        System.out.print("Root......: " + formatter.format(rootFinder.getBestPoint()) + "\t");
        System.out.print("Accuracy..: " + formatter.format(rootFinder.getAccuracy()) + "\t");
        System.out.print("Iterations: " + rootFinder.getNumberOfIterations() + "\n");
    }
}

