/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.RootFinder;

public class RiddersMethod
implements RootFinder {
    private final double[] points = new double[3];
    private final double[] values = new double[3];
    private double nextPoint;
    private int solverState = 0;
    private int numberOfIterations = 0;
    private double bestPoint;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;

    public static void main(String[] args) {
        RiddersMethod search = new RiddersMethod(-1.0, 5.0);
        while (search.getAccuracy() > 1.0E-13 && !search.isDone()) {
            double x = search.getNextPoint();
            double y = x - 0.656;
            search.setValue(y);
            System.out.println(search.getAccuracy());
        }
        System.out.println(search.getNumberOfIterations() + " " + search.getBestPoint());
    }

    public RiddersMethod(double leftPoint, double rightPoint) {
        this.points[0] = leftPoint;
        this.points[2] = rightPoint;
        this.points[1] = (this.points[0] + this.points[2]) / 2.0;
        this.nextPoint = this.points[0];
        this.bestPoint = this.points[1];
        this.accuracy = this.points[2] - this.points[0];
    }

    @Override
    public double getBestPoint() {
        return this.bestPoint;
    }

    @Override
    public double getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValue(double value) {
        switch (this.solverState) {
            default: {
                this.values[0] = value;
                this.nextPoint = this.points[2];
                ++this.solverState;
                break;
            }
            case 1: {
                this.values[2] = value;
                this.points[1] = 0.5 * (this.points[0] + this.points[2]);
                this.nextPoint = this.points[1];
                ++this.solverState;
                break;
            }
            case 2: {
                this.values[1] = value;
                double s = Math.sqrt(this.values[1] * this.values[1] - this.values[0] * this.values[2]);
                if (s == 0.0) {
                    this.isDone = true;
                }
                this.nextPoint = this.points[1] + (this.points[1] - this.points[0]) * (this.values[0] >= this.values[2] ? 1.0 : -1.0) * this.values[1] / s;
                ++this.solverState;
                break;
            }
            case 3: {
                if (value == 0.0) {
                    this.isDone = true;
                }
                if (RiddersMethod.sign(this.values[1], value) != this.values[1]) {
                    this.points[0] = this.points[1];
                    this.values[0] = this.values[1];
                    this.points[2] = this.nextPoint;
                    this.values[2] = value;
                } else if (RiddersMethod.sign(this.values[0], value) != this.values[0]) {
                    this.points[2] = this.nextPoint;
                    this.values[2] = value;
                } else if (RiddersMethod.sign(this.values[2], value) != this.values[2]) {
                    this.points[0] = this.nextPoint;
                    this.values[0] = value;
                } else {
                    System.err.println(this.getClass().getName() + ": Error: Never get here.");
                    this.isDone = true;
                    return;
                }
                this.points[1] = 0.5 * (this.points[0] + this.points[2]);
                this.nextPoint = this.points[1];
                this.solverState = 2;
            }
        }
        this.accuracy = Math.abs(this.points[2] - this.points[0]);
        this.bestPoint = this.points[1];
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    private static final double sign(double a, double b) {
        return b >= 0.0 ? (a >= 0.0 ? a : -a) : (a > 0.0 ? -a : a);
    }
}

