/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.RootFinderWithDerivative;

public class NewtonsMethod
implements RootFinderWithDerivative {
    private double nextPoint;
    private int numberOfIterations = 0;
    private double bestPoint;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;

    public NewtonsMethod(double guess) {
        this.nextPoint = guess;
        this.bestPoint = guess;
    }

    @Override
    public double getBestPoint() {
        return this.bestPoint;
    }

    @Override
    public double getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValueAndDerivative(double value, double derivative) {
        if (Math.abs(value) < this.accuracy) {
            this.accuracy = Math.abs(value);
            this.bestPoint = this.nextPoint;
        }
        this.nextPoint -= value / derivative;
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

