/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public class OptimizerFactoryLevenbergMarquardt
implements OptimizerFactoryInterface {
    private final int maxIterations;
    private final double errorTolerance;
    private final int maxThreads;

    public OptimizerFactoryLevenbergMarquardt(int maxIterations, double errorTolerance, int maxThreads) {
        this.maxIterations = maxIterations;
        this.errorTolerance = errorTolerance;
        this.maxThreads = maxThreads;
    }

    public OptimizerFactoryLevenbergMarquardt(int maxIterations, int maxThreads) {
        this(maxIterations, 0.0, maxThreads);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, null, null, null, targetValues);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] lowerBound, double[] upperBound, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, null, targetValues);
    }

    @Override
    public OptimizerInterface getOptimizer(final OptimizerInterface.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] lowerBound, double[] upperBound, double[] parameterSteps, double[] targetValues) {
        return new LevenbergMarquardt(initialParameters, targetValues, this.maxIterations, this.maxThreads){
            private static final long serialVersionUID = -1628631567190057495L;

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                objectiveFunction.setValues(parameters, values);
            }
        }.setErrorTolerance(this.errorTolerance).setParameterSteps(parameterSteps);
    }
}

