/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractProcess
implements AbstractProcessInterface,
Cloneable {
    private AbstractModelInterface model;
    private TimeDiscretizationInterface timeDiscretization;

    public AbstractProcess(TimeDiscretizationInterface timeDiscretization) {
        this.timeDiscretization = timeDiscretization;
    }

    public abstract Object getCloneWithModifiedSeed(int var1);

    @Override
    public void setModel(AbstractModelInterface model) {
        if (this.model != null) {
            throw new RuntimeException("Attempt to reuse process with a different model. This process is already associated with a model.");
        }
        this.model = model;
    }

    @Override
    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    public RandomVariableInterface[] getInitialState() {
        return this.model.getInitialState();
    }

    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        return this.model.getDrift(timeIndex, realizationAtTimeIndex, realizationPredictor);
    }

    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        return this.model.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
    }

    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return this.model.applyStateSpaceTransform(componentIndex, randomVariable);
    }

    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return this.model.applyStateSpaceTransformInverse(componentIndex, randomVariable);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int timeIndex) {
        if (timeIndex < 0 || timeIndex >= this.timeDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index for process time discretization out of bounds.");
        }
        return this.timeDiscretization.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    @Override
    public abstract AbstractProcess clone();
}

