/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class PerformanceIndex
extends AbstractIndex {
    private static final long serialVersionUID = -8181742829635380940L;
    private AbstractProductComponent numeratorIndex;
    private AbstractProductComponent denominatorIndex;

    public PerformanceIndex(AbstractProductComponent numeratorIndex, AbstractProductComponent denominatorIndex) {
        this.numeratorIndex = numeratorIndex;
        this.denominatorIndex = denominatorIndex;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        return this.numeratorIndex.getValue(evaluationTime, model).div(this.denominatorIndex.getValue(evaluationTime, model));
    }

    public AbstractProductComponent getNumeratorIndex() {
        return this.numeratorIndex;
    }

    public AbstractProductComponent getDenominatorIndex() {
        return this.denominatorIndex;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = this.numeratorIndex.queryUnderlyings();
        Set<String> underlyingNames2 = this.denominatorIndex.queryUnderlyings();
        if (underlyingNames2 != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNames2);
            } else {
                underlyingNames = underlyingNames2;
            }
        }
        return underlyingNames;
    }
}

