/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class AnalyticModelIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final String curveName;
    private final double fixingOffet;

    public AnalyticModelIndex(String name, String curveName, double fixingOffset) {
        super(name);
        this.curveName = curveName;
        this.fixingOffet = fixingOffset;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        AnalyticModelInterface analyticModel = model.getModel().getAnalyticModel();
        if (analyticModel == null) {
            throw new IllegalArgumentException("Provided model does not carry an associated analytic model.");
        }
        CurveInterface curve = analyticModel.getCurve(this.curveName);
        if (curve == null) {
            throw new IllegalArgumentException("Associated analytic model does not carry a curve of the name " + this.curveName + ".");
        }
        double index = curve.getValue(analyticModel, evaluationTime + this.fixingOffet);
        return model.getRandomVariableForConstant(index);
    }

    public double getPeriodStartOffset() {
        return this.fixingOffet;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "AnalyticModelIndex [curveName=" + this.curveName + ", fixingOffet=" + this.fixingOffet + "]";
    }
}

