/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public abstract class AbstractPeriod
extends AbstractProductComponent {
    private static final long serialVersionUID = 8035860121112226049L;
    private final double periodStart;
    private final double periodEnd;
    private final double fixingDate;
    private final double paymentDate;
    private final AbstractNotional notional;
    private final AbstractProductComponent index;
    private final double daycountFraction;

    @Override
    public abstract RandomVariableInterface getValue(double var1, LIBORModelMonteCarloSimulationInterface var3) throws CalculationException;

    public abstract RandomVariableInterface getCoupon(LIBORModelMonteCarloSimulationInterface var1) throws CalculationException;

    public AbstractPeriod(double periodStart, double periodEnd, double fixingDate, double paymentDate, AbstractNotional notional, AbstractProductComponent index, double daycountFraction) {
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.fixingDate = fixingDate;
        this.paymentDate = paymentDate;
        this.notional = notional;
        this.index = index;
        this.daycountFraction = daycountFraction;
    }

    public AbstractPeriod(double periodStart, double periodEnd, double fixingDate, double paymentDate, AbstractNotional notional, AbstractProductComponent index) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, periodEnd - periodStart);
    }

    @Override
    public String getCurrency() {
        return this.notional.getCurrency();
    }

    public double getPeriodStart() {
        return this.periodStart;
    }

    public double getPeriodEnd() {
        return this.periodEnd;
    }

    public double getFixingDate() {
        return this.fixingDate;
    }

    public double getPaymentDate() {
        return this.paymentDate;
    }

    public AbstractNotional getNotional() {
        return this.notional;
    }

    public AbstractProductComponent getIndex() {
        return this.index;
    }

    public double getDaycountFraction() {
        return this.daycountFraction;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.getIndex().queryUnderlyings();
    }

    @Override
    public String toString() {
        return "AbstractPeriod [periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", fixingDate=" + this.fixingDate + ", paymentDate=" + this.paymentDate + ", notional=" + this.notional + ", index=" + this.index + ", daycountFraction=" + this.daycountFraction + "]";
    }
}

