/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class Swaption
extends AbstractLIBORMonteCarloProduct {
    private double exerciseDate;
    private double[] fixingDates;
    private double[] paymentDates;
    private double[] periodLengths;
    private double[] swaprates;

    public Swaption(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] periodLengths, double[] swaprates) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = periodLengths;
        this.swaprates = swaprates;
    }

    public Swaption(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = null;
        this.swaprates = swaprates;
    }

    public Swaption(double exerciseDate, TimeDiscretizationInterface swapTenor, double swaprate) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = new double[swapTenor.getNumberOfTimeSteps()];
        this.paymentDates = new double[swapTenor.getNumberOfTimeSteps()];
        for (int periodIndex = 0; periodIndex < this.fixingDates.length; ++periodIndex) {
            this.fixingDates[periodIndex] = swapTenor.getTime(periodIndex);
            this.paymentDates[periodIndex] = swapTenor.getTime(periodIndex + 1);
        }
        this.periodLengths = null;
        this.swaprates = new double[swapTenor.getNumberOfTimeSteps()];
        Arrays.fill(this.swaprates, swaprate);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface valueOfSwapAtExerciseDate = model.getRandomVariableForConstant(0.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double swaprate = this.swaprates[period];
            if (paymentDate <= evaluationTime) break;
            double periodLength = this.periodLengths != null ? this.periodLengths[period] : paymentDate - fixingDate;
            RandomVariableInterface libor = model.getLIBOR(this.exerciseDate, fixingDate, paymentDate);
            RandomVariableInterface payoff = libor.sub(swaprate).mult(periodLength);
            double discountingDate = Math.max(fixingDate, this.exerciseDate);
            double discountingAdjustment = 1.0;
            if (model.getModel().getDiscountCurve() != null) {
                AnalyticModelInterface analyticModel = model.getModel().getAnalyticModel();
                DiscountCurveInterface discountCurve = model.getModel().getDiscountCurve();
                ForwardCurveInterface forwardCurve = model.getModel().getForwardRateCurve();
                DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(forwardCurve);
                double forwardBondOnForwardCurve = discountCurveFromForwardCurve.getDiscountFactor(analyticModel, discountingDate) / discountCurveFromForwardCurve.getDiscountFactor(analyticModel, paymentDate);
                double forwardBondOnDiscountCurve = discountCurve.getDiscountFactor(analyticModel, discountingDate) / discountCurve.getDiscountFactor(analyticModel, paymentDate);
                discountingAdjustment = forwardBondOnForwardCurve / forwardBondOnDiscountCurve;
            }
            valueOfSwapAtExerciseDate = valueOfSwapAtExerciseDate.add(payoff);
            valueOfSwapAtExerciseDate = valueOfSwapAtExerciseDate.discount(libor, paymentDate - discountingDate).mult(discountingAdjustment);
        }
        RandomVariableInterface values = valueOfSwapAtExerciseDate.floor(0.0);
        RandomVariableInterface numeraire = model.getNumeraire(this.exerciseDate);
        RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(this.exerciseDate);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariableInterface numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return values;
    }

    public double getValue(ForwardCurveInterface forwardCurve, double swaprateVolatility) {
        double swaprate = this.swaprates[0];
        for (double swaprate1 : this.swaprates) {
            if (swaprate1 == swaprate) continue;
            throw new RuntimeException("Uneven swaprates not allows for analytical pricing.");
        }
        double[] swapTenor = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, swapTenor, 0, this.fixingDates.length);
        swapTenor[swapTenor.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        double forwardSwapRate = Swap.getForwardSwapRate(new TimeDiscretization(swapTenor), new TimeDiscretization(swapTenor), forwardCurve);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(swapTenor), forwardCurve);
        return AnalyticFormulas.blackModelSwaptionValue(forwardSwapRate, swaprateVolatility, this.exerciseDate, swaprate, swapAnnuity);
    }

    @Override
    public String toString() {
        return super.toString() + "\nexerciseDate: " + this.exerciseDate + "\nfixingDates: " + Arrays.toString(this.fixingDates) + "\npaymentDates: " + Arrays.toString(this.paymentDates) + "\nperiodLengths: " + Arrays.toString(this.periodLengths) + "\nswaprates: " + Arrays.toString(this.swaprates);
    }
}

