/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SimpleSwap;
import net.finmath.montecarlo.interestrate.products.SwapLeg;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.ScheduleInterface;

public class Swap
extends AbstractLIBORMonteCarloProduct {
    private final AbstractLIBORMonteCarloProduct legReceiver;
    private final AbstractLIBORMonteCarloProduct legPayer;

    public Swap(AbstractLIBORMonteCarloProduct legReceiver, AbstractLIBORMonteCarloProduct legPayer) {
        this.legReceiver = legReceiver;
        this.legPayer = legPayer;
    }

    public Swap(AbstractNotional notional, ScheduleInterface scheduleReceiveLeg, AbstractIndex indexReceiveLeg, double spreadReceiveLeg, ScheduleInterface schedulePayLeg, AbstractIndex indexPayLeg, double spreadPayLeg) {
        this.legReceiver = new SwapLeg(scheduleReceiveLeg, notional, indexReceiveLeg, spreadReceiveLeg, false);
        this.legPayer = new SwapLeg(schedulePayLeg, notional, indexPayLeg, spreadPayLeg, false);
    }

    public Swap(double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this.legReceiver = new SimpleSwap(fixingDates, paymentDates, swaprates);
        this.legPayer = null;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface value = this.legReceiver.getValue(evaluationTime, model);
        if (this.legPayer != null) {
            value = value.sub(this.legPayer.getValue(evaluationTime, model));
        }
        return value;
    }
}

