/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.ConditionalExpectationEstimatorInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class BermudanSwaption
extends AbstractLIBORMonteCarloProduct {
    private final boolean[] isPeriodStartDateExerciseDate;
    private final double[] fixingDates;
    private final double[] periodLengths;
    private final double[] paymentDates;
    private final double[] periodNotionals;
    private final double[] swaprates;

    public BermudanSwaption(boolean[] isPeriodStartDateExerciseDate, double[] fixingDates, double[] periodLength, double[] paymentDates, double[] periodNotionals, double[] swaprates) {
        this.isPeriodStartDateExerciseDate = isPeriodStartDateExerciseDate;
        this.fixingDates = fixingDates;
        this.periodLengths = periodLength;
        this.paymentDates = paymentDates;
        this.periodNotionals = periodNotionals;
        this.swaprates = swaprates;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface valuesUnderlying = model.getRandomVariableForConstant(0.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double periodLength = this.periodLengths[period];
            double paymentDate = this.paymentDates[period];
            double notional = this.periodNotionals[period];
            double swaprate = this.swaprates[period];
            RandomVariableInterface libor = model.getLIBOR(fixingDate, fixingDate, fixingDate + periodLength);
            RandomVariableInterface payoff = libor.sub(swaprate).mult(periodLength).mult(notional);
            RandomVariableInterface numeraire = model.getNumeraire(paymentDate);
            RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            valuesUnderlying = valuesUnderlying.add(payoff);
            if (!this.isPeriodStartDateExerciseDate[period]) continue;
            RandomVariableInterface triggerValuesDiscounted = values.sub(valuesUnderlying);
            ConditionalExpectationEstimatorInterface conditionalExpectationOperator = this.getConditionalExpectationEstimator(fixingDate, model);
            RandomVariableInterface triggerValues = triggerValuesDiscounted.getConditionalExpectation(conditionalExpectationOperator);
            values = values.barrier(triggerValues, values, valuesUnderlying);
        }
        RandomVariableInterface numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return values;
    }

    public ConditionalExpectationEstimatorInterface getConditionalExpectationEstimator(double fixingDate, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(fixingDate, model));
        return condExpEstimator;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double fixingDate, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        RandomVariable basisFunction = new RandomVariable(1.0);
        basisFunctions.add(basisFunction);
        int fixingDateIndex = Arrays.binarySearch(this.fixingDates, fixingDate);
        if (fixingDateIndex < 0) {
            fixingDateIndex = -fixingDateIndex;
        }
        if (fixingDateIndex >= this.fixingDates.length) {
            fixingDateIndex = this.fixingDates.length - 1;
        }
        RandomVariableInterface rateShort = model.getLIBOR(fixingDate, fixingDate, this.paymentDates[fixingDateIndex]);
        basisFunctions.add(rateShort);
        basisFunctions.add(rateShort.pow(2.0));
        basisFunctions.add(rateShort.pow(3.0));
        RandomVariableInterface rateLong = model.getLIBOR(fixingDate, this.fixingDates[fixingDateIndex], this.paymentDates[this.paymentDates.length - 1]);
        basisFunctions.add(rateLong);
        basisFunctions.add(rateLong.pow(2.0));
        basisFunctions.add(rateLong.pow(3.0));
        RandomVariableInterface numeraire = model.getNumeraire(fixingDate);
        basisFunctions.add(numeraire);
        basisFunctions.add(numeraire.pow(2.0));
        basisFunctions.add(numeraire.pow(3.0));
        basisFunctions.add(rateLong.mult(numeraire));
        return basisFunctions.toArray(new RandomVariableInterface[basisFunctions.size()]);
    }
}

